
package cn.sylinx.horm.type.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Month;

import cn.sylinx.horm.type.JdbcType;

public class MonthTypeHandler extends BaseTypeHandler<Month> {

    @Override
    protected JdbcType getJdbcTypeMapper() {
        return JdbcType.INTEGER;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Month month) throws SQLException {
        ps.setInt(i, month.getValue());
    }

    @Override
    public Month getNullableResult(ResultSet rs, String columnName) throws SQLException {
        int month = rs.getInt(columnName);
        return month == 0 ? null : Month.of(month);
    }

    @Override
    public Month getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        int month = rs.getInt(columnIndex);
        return month == 0 ? null : Month.of(month);
    }

    @Override
    public Month getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        int month = cs.getInt(columnIndex);
        return month == 0 ? null : Month.of(month);
    }

}
