package cn.sylinx.horm.type;

import java.sql.Types;

public enum JdbcType implements JdbcTypeMapper {

    ARRAY(Types.ARRAY), //
    BIT(Types.BIT), //
    TINYINT(Types.TINYINT), //
    SMALLINT(Types.SMALLINT), //
    INTEGER(Types.INTEGER), //
    BIGINT(Types.BIGINT), //
    FLOAT(Types.FLOAT), //
    REAL(Types.REAL), //
    DOUBLE(Types.DOUBLE), //
    NUMERIC(Types.NUMERIC), //
    DECIMAL(Types.DECIMAL), //
    CHAR(Types.CHAR), //
    VARCHAR(Types.VARCHAR), //
    LONGVARCHAR(Types.LONGVARCHAR), //
    DATE(Types.DATE), //
    TIME(Types.TIME), //
    TIMESTAMP(Types.TIMESTAMP), //
    BINARY(Types.BINARY), //
    VARBINARY(Types.VARBINARY), //
    LONGVARBINARY(Types.LONGVARBINARY), //
    NULL(Types.NULL), //
    BLOB(Types.BLOB), //
    CLOB(Types.CLOB), //
    BOOLEAN(Types.BOOLEAN), //
    CURSOR(-10), // // Oracle
    NVARCHAR(Types.NVARCHAR), //
    NCHAR(Types.NCHAR), //
    NCLOB(Types.NCLOB), //
    REF(Types.REF), //
    DATALINK(Types.DATALINK), //
    ROWID(Types.ROWID), //
    LONGNVARCHAR(Types.LONGNVARCHAR), //
    SQLXML(Types.SQLXML), //
    DATETIMEOFFSET(-155), //
    REF_CURSOR(Types.REF_CURSOR), //
    TIME_WITH_TIMEZONE(Types.TIME_WITH_TIMEZONE), //
    TIMESTAMP_WITH_TIMEZONE(Types.TIMESTAMP_WITH_TIMEZONE), //
    OTHER(Types.OTHER);

    public final int typeCode;

    JdbcType(int code) {
        this.typeCode = code;
    }

    public int getJdbcTypeCode() {
        return typeCode;
    }

}
