package cn.sylinx.horm.resource.parse;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import com.googlecode.aviator.AviatorEvaluator;

import cn.sylinx.horm.core.common.Consts;
import cn.sylinx.horm.core.common.TypedParameter;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;

/**
 * sql 占位符解析处理器
 * 
 * @author han
 *
 */
public class SqlTokenHandler implements TokenHandler {

    private static final String NOT_NULL_FLAG = "!!";

    private Map<String, Object> params;

    @Override
    public void setParameterMap(Map<String, Object> parameterMap) {
        this.params = parameterMap;
    }

    @Override
    public Map<String, Object> getParameterMap() {
        return Collections.unmodifiableMap(params);
    }

    @Override
    public Object handle(String content) {
        return StrKit.isNotBlank(content) ? (params == null ? null : getTypedParameter(content)) : null;
    }

    private Object getTypedParameter(String content) {
        Object param = params.get(content);
        // 参数类型
        Object parameterTypeObject = params.get(content + Consts.TYPED_PARAMETER_POSTFIX);
        if (parameterTypeObject == null || !(parameterTypeObject instanceof Class)) {
            return param;
        }

        TypedParameter typedParameter = new TypedParameter();
        typedParameter.setParameter(param);
        typedParameter.setParameterType((Class<?>) parameterTypeObject);

        return typedParameter;
    }

    @Override
    public boolean condition(String condition) {

        if (params == null) {
            return false;
        }

        if (condition == null) {
            return false;
        }

        condition = condition.trim();
        if (condition.startsWith(NOT_NULL_FLAG)) {
            // 空判断
            String trueField = condition.substring(NOT_NULL_FLAG.length()).trim();
            if ("".equals(trueField)) {
                return false;
            }

            Object value = params.get(trueField);
            if (value == null) {
                return false;
            }

            // 如果是字符串，判断是否是空白字符串
            if (value instanceof String) {
                return !"".equals(value.toString());
            }

            // 如果是collection，判断是否有元素
            if (value instanceof Collection) {
                return !((Collection<?>) value).isEmpty();
            }

            return true;
        }

        try {
            Object ret = AviatorEvaluator.execute(condition, params, true);
            if (ret instanceof Boolean) {
                return (Boolean) ret;
            }
        } catch (Exception e) {
            GLog.error("execute error, exp:" + condition, e);
            throw new HORMException("error expression: " + condition);
        }

        return false;
    }
}
