package cn.sylinx.horm.resource.lexer;

import java.util.ArrayList;
import java.util.List;

/**
 * #IF[condition] ... #ELSIF[condition] ... #ELSE ... #END 块
 * 
 * @author han
 *
 */
class IfEndBlock {

    private IF ifNode;

    private List<ELSIF> elsifNodeList = new ArrayList<ELSIF>();

    private ELSE elseNode;

    private END endNode;

    public END getEndNode() {
        return endNode;
    }

    public String toString() {

        StringBuilder sb = new StringBuilder();
        sb.append("IFEND block(\n");
        sb.append("#IF:").append(ifNode.toString()).append(",\n");
        sb.append("#ELSIF:[");
        int len = elsifNodeList.size();

        for (int i = len - 1; i >= 0; --i) {
            ELSIF elsif = elsifNodeList.get(i);
            sb.append(elsif.toString()).append(",");
        }

        sb.append("],\n");
        sb.append("#ELSE:").append(elseNode == null ? "" : elseNode.toString()).append(",\n");
        sb.append("#END:").append(endNode == null ? "" : endNode.toString()).append(",\n");
        sb.append(")");
        return sb.toString();
    }

    public void setEndNode(END endNode) {
        this.endNode = endNode;
    }

    public List<ELSIF> getElsifNodeList() {
        return elsifNodeList;
    }

    public void addElsifNode(ELSIF elsif) {
        elsifNodeList.add(elsif);
    }

    public IF getIfNode() {
        return ifNode;
    }

    public void setIfNode(IF ifNode) {
        this.ifNode = ifNode;
    }

    public ELSE getElseNode() {
        return elseNode;
    }

    public void setElseNode(ELSE elseNode) {
        this.elseNode = elseNode;
    }

}
