package cn.sylinx.horm.resource.func.impl;

import java.util.Map;

import com.googlecode.aviator.AviatorEvaluator;

import cn.sylinx.horm.resource.func.IFunction;
import cn.sylinx.horm.resource.parse.TokenHandler;
import cn.sylinx.horm.resource.parse.ValueTokenHandler;
import cn.sylinx.horm.util.GLog;

/**
 * aviator表达式<br>
 * 使用方法 #FUNC[av,express]<br>
 * 
 * @author han
 *
 */
public class AviatorFunction implements IFunction {

    @Override
    public String sqlAlias() {
        return "av";
    }

    @Override
    public String invoke(ValueTokenHandler valueTokenHandler, String input) {

        Map<String, Object> root = null;
        if (valueTokenHandler != null && (valueTokenHandler instanceof TokenHandler)) {
            root = ((TokenHandler) valueTokenHandler).getParameterMap();
        }

        try {
            String trimmedInput = input.trim();

            return String.valueOf(AviatorEvaluator.execute(trimmedInput, root, true));
        } catch (Exception e) {
            GLog.error("AviatorFunction error:" + e.getMessage(), e);
        }

        return "";
    }

}
