package cn.sylinx.horm.resource.func.aviator;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorString;

import cn.sylinx.horm.exception.HORMException;

public class ForeachAviatorFunction extends AbstractFunction {

    //#FUNC[av, foreach(numberList, '(', ',', ')', \"'\")]
    @Override
    public String getName() {
        return "foreach";
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject argKey, AviatorObject openSymbol,
            AviatorObject splitSymbol, AviatorObject closeSymbol, AviatorObject quoteSymbol) {

        Object obj = FunctionUtils.getJavaObject(argKey, env);
        if (obj == null) {
            return AviatorFunctionConsts.EMPTY;
        }

        if (!(obj instanceof Collection)) {
            throw new HORMException("invalid arguments");
        }
        Collection<?> collections = (Collection<?>) obj;
        if (collections.isEmpty()) {
            return AviatorFunctionConsts.EMPTY;
        }

        String openSymbolStr = FunctionUtils.getStringValue(openSymbol, env);
        String splitSymbolStr = FunctionUtils.getStringValue(splitSymbol, env);
        String closeSymbolStr = FunctionUtils.getStringValue(closeSymbol, env);
        String quote = FunctionUtils.getStringValue(quoteSymbol, env);

        Iterator<?> it = collections.iterator();

        StringBuilder sb = new StringBuilder();
        sb.append(openSymbolStr);
        while (it.hasNext()) {
            sb.append(quote).append(it.next().toString()).append(quote).append(splitSymbolStr);
        }
        int splitLen = splitSymbolStr.length();
        int totalLen = sb.length();

        sb.delete(totalLen - splitLen, totalLen);
        sb.append(closeSymbolStr);

        return new AviatorString(sb.toString());
    }

}
