package cn.sylinx.horm.resource.func;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.lexer.Tags;
import cn.sylinx.horm.resource.parse.ValueTokenHandler;
import cn.sylinx.horm.util.Pair;

public class FunctionParser {

    private static char escape = '\\';
    private static String escapeClose = "\\]";

    private ValueTokenHandler handler;

    public FunctionParser(ValueTokenHandler handler) {
        this.handler = handler;
    }

    public static final String TOKEN_FUN_BEGIN_QUOTE = "[";
    public static final String TOKEN_FUN_BEGIN = Tags.KW_FUNC + TOKEN_FUN_BEGIN_QUOTE;
    public static final String TOKEN_FUN_END = "]";

    public String parse(String statement) {
        return parseDynamicSql(statement).toString();
    }

    private String parseDynamicSql(String st) {

        StringBuilder sb = new StringBuilder();
        parseSqlNext(st, sb);
        return sb.toString();
    }

    private void parseSqlNext(String st, StringBuilder sb) {

        if (st == null) {
            throw new RuntimeException("statment is null");
        }

        int is = st.indexOf(TOKEN_FUN_BEGIN);
        if (is == -1) {
            sb.append(st);
            return;
        }

        String tmp = st.substring(is);
        Pair p = parseFunctionContent(tmp);
        int is1 = p.getFirst();
        String split = p.getSecond();

        // int is1 = tmp.indexOf(TOKEN_FUN_END);
        int ie = is1 + is;

        // if (is1 == -1) {
        // throw new RuntimeException("illegal function statement");
        // }
        // String split = st.substring(is + TOKEN_FUN_BEGIN.length(), ie);

        // 解析函数
        String dynamicSql = handFunction(split);

        String before = st.substring(0, is) + (dynamicSql == null ? "" : dynamicSql);
        sb.append(before);

        String after = st.substring(ie + TOKEN_FUN_END.length());
        parseSqlNext(after, sb);
    }

    private Pair parseFunctionContent(String left) {

        int startIndex = TOKEN_FUN_BEGIN.length();

        int len = left.length();
        for (int i = 0; i < len; ++i) {
            if (Tags.TOKEN_CON_END_CHAR == left.charAt(i)) {
                // 找到结束，需要判断是否转义
                if (i > startIndex) {
                    int pre1 = left.charAt(i - 1);
                    if (escape != pre1) {
                        return Pair.apply(i, convertEscapeCondition(left.substring(startIndex, i)));
                    }

                    int pre2 = left.charAt(i - 2);
                    if (escape == pre1 && escape == pre2) {
                        return Pair.apply(i, convertEscapeCondition(left.substring(startIndex, i)));
                    }

                    continue;
                }
            }
        }

        throw new HORMException("illegal function statement");
    }

    private String convertEscapeCondition(String con) {
        if (con.contains(escapeClose)) {
            return con.replace(escapeClose, Tags.TOKEN_CON_END);
        }
        return con;
    }

    private String handFunction(String split) {

        int index = split.indexOf(",");
        if (index == -1) {
            throw new HORMException("函数参数错误");
        }
        String alias = split.substring(0, index);
        String input = split.substring(index + 1);
        IFunction af = FunctionFactory.get().getFunction(alias);
        if (af == null) {
            throw new HORMException("对应函数[" + alias + "]不存在");
        }
        return af.invoke(handler, input);
    }
}
