package cn.sylinx.horm.resource;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.config.ParseSqlType;

public class ClasspathSqlResource {

    private String sqlpath;
    private StatementHandler statementHandler;
    private boolean format = true;
    private String type;

    public static ClasspathSqlResource applySystemResource(String sqlPath) {
        return apply(sqlPath, ParseSqlType.SYSTEM.getType());
    }

    public static ClasspathSqlResource applyAviatorResource(String sqlPath) {
        return apply(sqlPath, ParseSqlType.AVIATOR.getType());
    }

    public static ClasspathSqlResource apply(String sqlPath) {
        return apply(sqlPath, OrmConfigHolder.getParseSqlType());
    }

    public static ClasspathSqlResource apply(String sqlPath, String type) {
        return new ClasspathSqlResource(sqlPath, type);
    }

    public ClasspathSqlResource() {
    }

    public ClasspathSqlResource(String sqlpath) {
        this(sqlpath, OrmConfigHolder.getParseSqlType());
    }

    public ClasspathSqlResource(String sqlpath, String type) {
        this.sqlpath = sqlpath;
        this.type = type;
    }

    public StatementHandler getStatementHandler() {
        return statementHandler;
    }

    public void setStatementHandler(StatementHandler statementHandler) {
        this.statementHandler = statementHandler;
    }

    public SqlResourceType getSqlResourceType() {
        return SqlResourceType.CLASSPATHSQL;
    }

    public String getSqlResource() {
        return getSqlpath();
    }

    public String getSqlpath() {
        return sqlpath;
    }

    public void setSqlpath(String sqlpath) {
        this.sqlpath = sqlpath;
    }

    public boolean isFormat() {
        return format;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

}
