package cn.sylinx.horm.proxy.mapper.interceptor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import cn.sylinx.horm.interceptor.Invocation;
import cn.sylinx.horm.proxy.mapper.invoker.MapperInvoker;
import cn.sylinx.horm.util.ClassUtil;

public class MapperInvokerProxy implements InvocationHandler {

    private MapperInvoker mapperInvoker;

    public MapperInvokerProxy(MapperInvoker mapperInvoker) {
        this.mapperInvoker = mapperInvoker;
    }

    public static MapperInvoker create(MapperInvoker mapperInvoker) {
        return (MapperInvoker) Proxy.newProxyInstance(ClassUtil.getDefaultClassLoader(),
                new Class<?>[] { MapperInvoker.class }, new MapperInvokerProxy(mapperInvoker));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke(this, args);
        }
        return MapperInterceptorManager.INSTANCE.getInterceptor()
                .intercept(new Invocation(mapperInvoker, method, args));
    }
}
