package cn.sylinx.horm.dialect.spi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

import cn.sylinx.horm.dialect.Dialect;
import cn.sylinx.horm.util.ClassUtil;
import cn.sylinx.horm.util.GLog;

public enum DialectSPIManager {

    ;

    private static Map<String, Dialect> spiDialectMap = new HashMap<>();

    static {
        init();
    }

    private static final void init() {
        ServiceLoader<Dialect> dialects = ServiceLoader.load(Dialect.class, ClassUtil.getDefaultClassLoader());
        if (dialects != null) {
            Iterator<Dialect> dialectIt = dialects.iterator();
            while (dialectIt.hasNext()) {
                Dialect dialect = dialectIt.next();
                String dbtype = dialect.getDbType().getValue();
                spiDialectMap.put(dbtype, dialect);
                GLog.info("register spi dbtype:{}", dbtype);
            }
        }
    }

    public static Dialect createDialectBySPI(String dbTypeName) {
        return spiDialectMap.get(dbTypeName);
    }

}
