package cn.sylinx.horm.core.common;

import cn.sylinx.horm.type.handler.TypeHandler;

/**
 * 携带参数类型的参数
 * 
 * @author johnhan
 *
 */
public class TypedParameter {

    private Object parameter;

    private Class<?> parameterType;

    private TypeHandler<?> typeHandler;

    public Object getParameter() {
        return parameter;
    }

    public TypedParameter setParameter(Object parameter) {
        this.parameter = parameter;
        return this;
    }

    public Class<?> getParameterType() {
        return parameterType;
    }

    public TypedParameter setParameterType(Class<?> parameterType) {
        this.parameterType = parameterType;
        return this;
    }

    public TypeHandler<?> getTypeHandler() {
        return typeHandler;
    }

    public void setTypeHandler(TypeHandler<?> typeHandler) {
        this.typeHandler = typeHandler;
    }

    @Override
    public String toString() {
        return "TypedParameter [parameter=" + parameter + ", parameterType=" + parameterType + ", typeHandler="
                + (typeHandler == null ? null : typeHandler.getClass().getName()) + "]";
    }

}
