package cn.sylinx.horm.config;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

import cn.sylinx.horm.resource.ClasspathSqlResourceManager;
import cn.sylinx.horm.resource.io.SqlResourceScanner;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;

class SqlResourceLoader {

    private OrmConfig ormConfig;

    SqlResourceLoader(OrmConfig ormConfig) {
        this.ormConfig = ormConfig;
    }

    public void load() {

        String sqlPath = ormConfig.getSqlPath();
        if (StrKit.isBlank(sqlPath)) {
            load(null);
            return;
        }

        String[] pathArray = sqlPath.split(",");
        List<String> resourcePaths = Arrays.asList(pathArray);
        if (resourcePaths == null) {
            return;
        }
        resourcePaths.stream().filter(StrKit::isNotBlank).forEach(item -> {
            boolean bl = load(item);
            if (bl) {
                GLog.info("classpath resources:'{}' load ok，sql resource postfix:{}", item, ormConfig.getSqlPostfix());
            } else {
                GLog.warn("classpath resources:'{}' loaded, but no resource，sql resource postfix:{}", item, ormConfig.getSqlPostfix());
            }
        });
    }

    private String getSqlPostfix() {
        String sqlPostfix = ormConfig.getSqlPostfix();
        if (StrKit.isBlank(sqlPostfix)) {
            sqlPostfix = OrmConfig.DEFAULT_SQL_POST_FIX;
        }
        return sqlPostfix;
    }

    private boolean load(String resourcesPath) {

        SqlResourceScanner ss = new SqlResourceScanner(resourcesPath, getSqlPostfix());
        Set<Object> sqlSets = ss.scan(true);

        if (sqlSets == null || sqlSets.isEmpty()) {
            return false;
        }

        for (Object sql : sqlSets) {
            ClasspathSqlResourceManager.load(String.valueOf(sql));
            GLog.info("SQL资源:[{}]已加载 ", sql);
        }
        return true;
    }
}