package cn.sylinx.horm.config;

public enum ParseSqlType {

    SYSTEM("system"), // 默认系统

    AVIATOR("aviator"); // 使用aviator解析

    private String type;

    private ParseSqlType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }
    
    public static ParseSqlType getByType(String type) {
        ParseSqlType[] vs = ParseSqlType.values();
        for(ParseSqlType v : vs) {
            if(v.type.equals(type)) {
                return v;
            }
        }
        return null;
    }

}
