package cn.sylinx.horm.config;

import cn.sylinx.horm.model.anno.Model;
import cn.sylinx.horm.model.cache.ModelCacheManager;
import cn.sylinx.horm.resource.io.ClassScanner;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;

class ModelCacheLoader {

    private OrmConfig ormConfig;

    ModelCacheLoader(OrmConfig ormConfig) {
        this.ormConfig = ormConfig;
    }

    public void load() {

        // Model 扫描包，如果为空，则全项目扫描
        String modelScanPackage = ormConfig.getModelScanPackage();

        if (StrKit.isBlank(modelScanPackage)) {
            // modelScanPackage
            modelScanPackage = "";
            GLog.warn("horm.config.model-scan-package没有配置，这将导致花费更多时间扫描整个项目");
        }
        GLog.info("扫描包:{}, 寻找@Model对象", StrKit.isBlank(modelScanPackage) ? "整个项目" : modelScanPackage);

        ModelCacheManager.initByClassSets(ClassScanner.scanAllPackageByAnnotation(modelScanPackage, Model.class));

        GLog.info("寻找@Model对象完毕，总计:{}", ModelCacheManager.cachedSize());
    }
}
