/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.func.impl;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.func.IFunction;
import cn.sylinx.horm.resource.parse.ValueTokenHandler;
import cn.sylinx.horm.util.StrKit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;

public class Exclude
implements IFunction {
    @Override
    public String sqlAlias() {
        return "exclude";
    }

    @Override
    public String invoke(ValueTokenHandler valueTokenHandler, String inputStr) {
        String[] kv = inputStr.split(",");
        if (kv == null || kv.length < 2) {
            throw new HORMException(this.sqlAlias() + "\u51fd\u6570\u7684\u5165\u53c2\u9519\u8bef");
        }
        String field = kv[0].trim();
        String params = kv[1].trim();
        String type = null;
        Optional<Object> optional = Optional.of(valueTokenHandler.handle(params));
        Object value = optional.get();
        if (kv.length == 3) {
            type = kv[2].trim();
        }
        if (StrKit.isBlank(type)) {
            type = "0";
        }
        boolean useAnd = "0".equals(type);
        ArrayList<String> valueList = new ArrayList<String>();
        if (value.getClass().isArray()) {
            Object[] ary = (Object[])value;
            for (Object v : ary) {
                if (v instanceof Number) {
                    valueList.add(v.toString());
                    continue;
                }
                valueList.add("'" + v.toString() + "'");
            }
        } else if (value instanceof Collection) {
            Collection c = (Collection)value;
            for (Object v : c) {
                if (v instanceof Number) {
                    valueList.add(v.toString());
                    continue;
                }
                valueList.add("'" + v.toString() + "'");
            }
        } else if (value instanceof Number) {
            valueList.add(value.toString());
        } else {
            valueList.add("'" + value.toString() + "'");
        }
        StringBuilder sb = new StringBuilder();
        if (valueList.size() == 1) {
            sb.append(" ").append(field).append(" != ").append((String)valueList.get(0));
        } else if (useAnd) {
            String token = " AND ";
            sb.append(" ").append("(");
            for (String item : valueList) {
                sb.append(field).append(" != ").append(item).append(token);
            }
            sb.delete(sb.length() - token.length(), sb.length());
            sb.append(")").append(" ");
        } else {
            sb.append(" ").append(field).append(" ");
            sb.append("not in (");
            for (String item : valueList) {
                sb.append(item).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")").append(" ");
        }
        return sb.toString();
    }
}

