/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.proxy.mapper.parse;

import cn.sylinx.horm.core.datasource.dynamic.DynamicDatasourceProvider;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.proxy.mapper.parse.Namespace;
import cn.sylinx.horm.proxy.mapper.parse.SqlItem;
import cn.sylinx.horm.util.StrKit;
import cn.sylinx.horm.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum NamespaceContainer {

    private static final Map<String, Namespace> container = new HashMap<String, Namespace>();

    public static void register(Namespace namespace) {
        container.put(namespace.getId(), namespace);
    }

    public static Namespace get(String id) {
        return container.get(id);
    }

    public static Namespace get(Class<?> mapperClass) {
        return NamespaceContainer.get(mapperClass.getName());
    }

    public static Tuple getMapper(Class<?> mapperClass, String methodName) {
        Namespace ns = NamespaceContainer.get(mapperClass);
        if (ns == null) {
            throw new HORMException("invalid mapper class or unregistered");
        }
        Map<String, SqlItem> sqlItems = ns.getSqlItems();
        if (sqlItems == null) {
            throw new HORMException("invalid xml mapper");
        }
        SqlItem sqlItem = sqlItems.get(methodName);
        if (sqlItem == null) {
            throw new HORMException("sqlId " + methodName + " not found");
        }
        String truelyDatasource = ns.isDynamic() ? DynamicDatasourceProvider.create().getDatasource() : (StrKit.isBlank(sqlItem.getDatasource()) ? (StrKit.isBlank(ns.getDatasource()) ? "_DEFAULT_DS_NAME_FOR_HORM_" : ns.getDatasource()) : sqlItem.getDatasource());
        return Tuple.apply(ns, sqlItem, truelyDatasource);
    }

    public static List<Class<?>> getAllMapperClass() {
        ArrayList maperClass = new ArrayList();
        Set<Map.Entry<String, Namespace>> namespaces = container.entrySet();
        namespaces.forEach(entry -> maperClass.add(((Namespace)entry.getValue()).getMapperClass()));
        return maperClass;
    }
}

