/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.model.util;

import cn.sylinx.horm.model.anno.Column;
import cn.sylinx.horm.model.anno.Table;
import cn.sylinx.horm.model.cache.ModelCacheUtil;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.util.StrKit;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelByDialectUtil {
    public static final void buildColumnNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }

    private static boolean isIgnoreField(Field f) {
        String modifiers = Modifier.toString(f.getModifiers());
        if (modifiers.contains("final") || modifiers.contains("static") || modifiers.contains("transient") || f.getName().equals("context")) {
            return true;
        }
        Column cd = f.getAnnotation(Column.class);
        return cd != null && cd.ignore();
    }

    public static List<Field> getObjectAllFields(Class<?> cclz) {
        List<Field> fds1;
        Class<?> pclz;
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] fs = cclz.getDeclaredFields();
        if (fs != null && fs.length > 0) {
            for (Field f : fs) {
                if (ModelByDialectUtil.isIgnoreField(f)) continue;
                fields.add(f);
            }
        }
        if ((pclz = cclz.getSuperclass()) != null && !pclz.isInterface() && (fds1 = ModelByDialectUtil.getObjectAllFields(pclz)) != null && !fds1.isEmpty()) {
            fields.addAll(fds1);
        }
        return fields;
    }

    public static Map<String, Field> getObjectAllFieldsMap(Class<?> cclz) {
        Map<String, Field> fds1;
        Class<?> pclz;
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field[] fs = cclz.getDeclaredFields();
        if (fs != null && fs.length > 0) {
            for (Field f : fs) {
                if (ModelByDialectUtil.isIgnoreField(f)) continue;
                fields.put(f.getName(), f);
                fields.put(f.getName().toUpperCase(), f);
            }
        }
        if ((pclz = cclz.getSuperclass()) != null && !pclz.isInterface() && (fds1 = ModelByDialectUtil.getObjectAllFieldsMap(pclz)) != null && !fds1.isEmpty()) {
            fields.putAll(fds1);
        }
        return fields;
    }

    public static String getModelTable(Class<?> clz) {
        Table table = clz.getAnnotation(Table.class);
        if (table != null) {
            return table.value();
        }
        return StrKit.enCodeUnderlined(clz.getSimpleName());
    }

    public static String buildColumnsByExcluded(Class<?> clz, List<String> excludedColumns) {
        return ModelByDialectUtil.buildColumnsByExcluded(clz, excludedColumns, false, null, null);
    }

    public static String buildMySQLColumnsByExcluded(Class<?> clz, List<String> excludedColumns) {
        return ModelByDialectUtil.buildColumnsByExcluded(clz, excludedColumns, true, "`", "`");
    }

    public static String buildOracleColumnsByExcluded(Class<?> clz, List<String> excludedColumns) {
        String preEscape = "\"";
        String postEscape = "\"";
        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        Map<String, String> attrs = mf.getRawAttrMapping();
        HashSet<String> columns = new HashSet<String>();
        Set<Map.Entry<String, String>> kvsets = attrs.entrySet();
        for (Map.Entry<String, String> entry : kvsets) {
            if (excludedColumns.contains(entry.getKey()) || excludedColumns.contains(entry.getValue()) || excludedColumns.contains(entry.getValue().toLowerCase())) continue;
            columns.add(preEscape + entry.getValue().toUpperCase() + postEscape);
        }
        StringBuilder sb = new StringBuilder();
        columns.forEach(k -> sb.append((String)k).append(","));
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String buildColumnsByExcluded(Class<?> clz, List<String> excludedColumns, boolean useSymbol, String preEscape, String postEscape) {
        ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
        Map<String, String> attrs = mf.getRawAttrMapping();
        HashSet<String> columns = new HashSet<String>();
        Set<Map.Entry<String, String>> kvsets = attrs.entrySet();
        for (Map.Entry<String, String> entry : kvsets) {
            if (excludedColumns.contains(entry.getKey()) || excludedColumns.contains(entry.getValue()) || excludedColumns.contains(entry.getValue().toLowerCase())) continue;
            if (useSymbol) {
                columns.add(preEscape + entry.getValue() + postEscape);
                continue;
            }
            columns.add(entry.getValue().toUpperCase());
        }
        StringBuilder sb = new StringBuilder();
        columns.forEach(k -> sb.append((String)k).append(","));
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

