/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.core;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.config.specific.SpecificConfigHolder;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.core.interceptor.SqlClientProxy;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import java.util.HashMap;
import java.util.Map;

public enum DynamicClient {

    public static final String DEFAULT_DS_NAME = "_DEFAULT_DS_NAME_FOR_HORM_";
    private static Map<String, SqlClient> clientMaps = new HashMap<String, SqlClient>();

    public static SqlClient get() {
        return DynamicClient.get(DEFAULT_DS_NAME);
    }

    public static SqlClient get(String dsName) {
        SqlClient sqlClient;
        if (StrKit.isBlank(dsName)) {
            dsName = DEFAULT_DS_NAME;
        }
        if ((sqlClient = clientMaps.get(dsName)) == null) {
            throw new HORMException("SqlClient NOT FOUND by name:" + dsName);
        }
        return sqlClient;
    }

    static void register(SqlClient sqlClient) {
        GLog.info("Cached SqlClient:{}", sqlClient.getDataSourceName());
        clientMaps.put(sqlClient.getDataSourceName(), DynamicClient.maybeProxyed(sqlClient));
    }

    private static SqlClient maybeProxyed(SqlClient sqlClient) {
        return OrmConfigHolder.hasSqlClientInterceptor() ? (SpecificConfigHolder.isSqlClientInterceptorEnable(sqlClient.getDataSourceName()) ? SqlClientProxy.create(sqlClient) : sqlClient) : sqlClient;
    }
}

