/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.config.specific;

import cn.sylinx.horm.config.OrmConfig;
import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.config.specific.SpecificConfig;
import cn.sylinx.horm.util.GLog;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum SpecificConfigHolder {

    private static Map<String, SpecificConfig> dataSourceConfigMaps = new HashMap<String, SpecificConfig>();

    public static void init(OrmConfig ormConfig, Map<String, SpecificConfig> dataSourceConfig) {
        if (dataSourceConfig != null && !dataSourceConfig.isEmpty()) {
            Set<Map.Entry<String, SpecificConfig>> entrySet = dataSourceConfig.entrySet();
            for (Map.Entry<String, SpecificConfig> entry : entrySet) {
                SpecificConfigHolder.addSpecificConfig(ormConfig, entry.getKey(), entry.getValue());
            }
        }
    }

    public static void addSpecificConfig(OrmConfig ormConfig, String specificKey, SpecificConfig specificConfig) {
        SpecificConfigHolder.loadSpecific(ormConfig, specificKey, specificConfig);
        dataSourceConfigMaps.put(specificKey, (SpecificConfig)specificConfig.clone());
        GLog.info("addSpecificConfig, specificKey:{}, specificConfig:{}", specificKey, specificConfig);
    }

    private static void loadSpecific(OrmConfig ormConfig, String specificKey, SpecificConfig baseConfig) {
    }

    public static boolean isCache(String dataSourceName) {
        SpecificConfig config = dataSourceConfigMaps.get(dataSourceName);
        if (config == null) {
            return OrmConfigHolder.isCache();
        }
        return OrmConfigHolder.isCache() ? config.isCache() : false;
    }

    public static boolean isSqlStatOpen(String dataSourceName) {
        SpecificConfig config = dataSourceConfigMaps.get(dataSourceName);
        if (config == null) {
            return OrmConfigHolder.isSqlStatOpen();
        }
        return OrmConfigHolder.isSqlStatOpen() ? config.isSqlStatOpen() : false;
    }

    public static boolean isSqlClientInterceptorEnable(String dataSourceName) {
        SpecificConfig config = dataSourceConfigMaps.get(dataSourceName);
        if (config == null) {
            return true;
        }
        return OrmConfigHolder.getSqlClientInterceptor() != null ? config.isSqlClientInterceptorEnable() : false;
    }
}

