
package cn.sylinx.horm.type.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;

import cn.sylinx.horm.type.JdbcType;

public class InstantTypeHandler extends BaseTypeHandler<Instant> {

	@Override
	protected JdbcType getJdbcTypeMapper() {
		return JdbcType.TIMESTAMP;
	}

	@Override
	public void setNonNullParameter(PreparedStatement ps, int i, Instant parameter)
			throws SQLException {
		ps.setTimestamp(i, Timestamp.from(parameter));
	}

	@Override
	public Instant getNullableResult(ResultSet rs, String columnName) throws SQLException {
		Timestamp timestamp = rs.getTimestamp(columnName);
		return getInstant(timestamp);
	}

	@Override
	public Instant getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
		Timestamp timestamp = rs.getTimestamp(columnIndex);
		return getInstant(timestamp);
	}

	@Override
	public Instant getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
		Timestamp timestamp = cs.getTimestamp(columnIndex);
		return getInstant(timestamp);
	}

	private static Instant getInstant(Timestamp timestamp) {
		if (timestamp != null) {
			return timestamp.toInstant();
		}
		return null;
	}
}
