
package cn.sylinx.horm.type.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

import cn.sylinx.horm.type.JdbcType;

public class DateOnlyTypeHandler extends BaseTypeHandler<Date> {

	@Override
	protected JdbcType getJdbcTypeMapper() {
		return JdbcType.DATE;
	}

	@Override
	public void setNonNullParameter(PreparedStatement ps, int i, Date parameter)
			throws SQLException {
		ps.setDate(i, new java.sql.Date(parameter.getTime()));
	}

	@Override
	public Date getNullableResult(ResultSet rs, String columnName) throws SQLException {
		java.sql.Date sqlDate = rs.getDate(columnName);
		if (sqlDate != null) {
			return new Date(sqlDate.getTime());
		}
		return null;
	}

	@Override
	public Date getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
		java.sql.Date sqlDate = rs.getDate(columnIndex);
		if (sqlDate != null) {
			return new Date(sqlDate.getTime());
		}
		return null;
	}

	@Override
	public Date getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
		java.sql.Date sqlDate = cs.getDate(columnIndex);
		if (sqlDate != null) {
			return new Date(sqlDate.getTime());
		}
		return null;
	}

}
