
package cn.sylinx.horm.type.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import cn.sylinx.horm.type.JdbcType;

public class CharacterTypeHandler extends BaseTypeHandler<Character> {

	@Override
	protected JdbcType getJdbcTypeMapper() {
		return JdbcType.VARCHAR;
	}
	
	@Override
	public void setNonNullParameter(PreparedStatement ps, int i, Character parameter)
			throws SQLException {
		ps.setString(i, parameter.toString());
	}

	@Override
	public Character getNullableResult(ResultSet rs, String columnName) throws SQLException {
		String columnValue = rs.getString(columnName);
		if (columnValue != null) {
			return columnValue.charAt(0);
		} else {
			return null;
		}
	}

	@Override
	public Character getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
		String columnValue = rs.getString(columnIndex);
		if (columnValue != null) {
			return columnValue.charAt(0);
		} else {
			return null;
		}
	}

	@Override
	public Character getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
		String columnValue = cs.getString(columnIndex);
		if (columnValue != null) {
			return columnValue.charAt(0);
		} else {
			return null;
		}
	}
}
