
package cn.sylinx.horm.resource.block;

interface Tags {

	static String KW_IF = "#IF";
	static String KW_ELSIF = "#ELSIF";
	static String KW_ELSE = "#ELSE";
	static String KW_END = "#END";
	static String KW_FUNC = "#FUNC";

	// 条件符号
	static String TOKEN_CON_END = "]";
	static String VAR_PREFIX = "#{";

	/**
	 * 是否接近关键词
	 * 
	 * @param kw
	 * @return
	 */
	static boolean isSeeminglyKeyworld(String kw) {

		if (Tags.KW_IF.startsWith(kw) || Tags.KW_ELSIF.startsWith(kw) || Tags.KW_ELSE.startsWith(kw)
				|| Tags.KW_END.startsWith(kw) || Tags.KW_FUNC.startsWith(kw) || Tags.VAR_PREFIX.startsWith(kw)) {
			return true;
		}

		return false;
	}
}
