package cn.sylinx.horm.pool;

public enum PoolType {

	// druid
	Druid("com.alibaba.druid.pool.DruidDataSource"),
	// TomcatJdbc
	TomcatJdbc("org.apache.tomcat.jdbc.pool.DataSource"),
	// BoneCP
	BoneCP("com.jolbox.bonecp.BoneCPDataSource"),
	// C3P0
	C3P0("com.mchange.v2.c3p0.ComboPooledDataSource"),
	// Dbcp2
	Dbcp2("org.apache.commons.dbcp2.BasicDataSource"),
	// Dbcp
	Dbcp("org.apache.commons.dbcp.BasicDataSource"),
	// Hikari
	Hikari("com.zaxxer.hikari.HikariDataSource");

	private String className;

	private PoolType(String className) {
		this.className = className;
	}

	public String getClassName() {
		return className;
	}

	public static PoolType getPoolType(String poolTypeName) {

		PoolType[] dbts = PoolType.values();
		for (PoolType item : dbts) {
			if (item.name().equalsIgnoreCase(poolTypeName)) {
				return item;
			}
		}
		return null;
	}
}
