package cn.sylinx.horm.pool;

import com.zaxxer.hikari.HikariDataSource;

public class HikariDataSourceCreator extends AbstractDataSourceCreator<HikariDataSource> {

	@Override
	HikariDataSource createBaseDataSource(String driver, String url, String username, String password, String dbType) {

		HikariDataSource cds = new HikariDataSource();
		cds.setJdbcUrl(url);
		cds.setDriverClassName(driver);
		cds.setUsername(username);
		cds.setPassword(password);
		return cds;
	}
}
