package cn.sylinx.horm.pool;

import java.util.Properties;

import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;

import cn.sylinx.horm.util.GLog;

public class DbcpDataSourceCreator extends AbstractDataSourceCreator<BasicDataSource> {

	@Override
	BasicDataSource createBaseDataSource(String driver, String url, String username, String password, String dbType) {
		Properties p = new Properties();
		p.setProperty("driverClassName", driver);
		p.setProperty("url", url);
		p.setProperty("username", username);
		p.setProperty("password", password);

		try {
			return (BasicDataSource) BasicDataSourceFactory.createDataSource(p);
		} catch (Exception e) {
			GLog.error("createDataSource error", e);
		}
		return null;
	}

}
