package cn.sylinx.horm.model.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import cn.sylinx.horm.model.anno.Column;
import cn.sylinx.horm.model.anno.Table;
import cn.sylinx.horm.model.cache.ModelCacheUtil;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.util.StrKit;

public class ModelByDialectUtil {

	public static final void buildColumnNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types)
			throws SQLException {
		for (int i = 1; i < labelNames.length; i++) {
			labelNames[i] = rsmd.getColumnLabel(i);
			types[i] = rsmd.getColumnType(i);
		}
	}

	/**
	 * 是否忽略的字段
	 * 
	 * @param f
	 * @return
	 */
	private static boolean isIgnoreField(Field f) {

		String modifiers = Modifier.toString(f.getModifiers());

		if (modifiers.contains("final") || modifiers.contains("static") || modifiers.contains("transient")
				|| f.getName().equals("context")) {

			return true;
		}

		Column cd = f.getAnnotation(Column.class);
		if (cd != null && cd.ignore()) {
			// 忽略字段
			return true;
		}

		return false;
	}

	public static List<Field> getObjectAllFields(Class<?> cclz) {

		List<Field> fields = new ArrayList<Field>();

		Field[] fs = cclz.getDeclaredFields();

		if (fs != null && fs.length > 0) {
			for (Field f : fs) {
				if (!isIgnoreField(f)) {
					fields.add(f);
				}
			}
		}

		Class<?> pclz = cclz.getSuperclass();

		if (pclz != null && !pclz.isInterface()) {

			List<Field> fds1 = getObjectAllFields(pclz);
			if (fds1 != null && !fds1.isEmpty()) {
				fields.addAll(fds1);
			}
		}

		return fields;

	}

	public static Map<String, Field> getObjectAllFieldsMap(Class<?> cclz) {

		Map<String, Field> fields = new HashMap<String, Field>();

		Field[] fs = cclz.getDeclaredFields();

		if (fs != null && fs.length > 0) {
			for (Field f : fs) {
				if (!isIgnoreField(f)) {
					fields.put(f.getName(), f);
					fields.put(f.getName().toUpperCase(), f);
				}
			}
		}

		Class<?> pclz = cclz.getSuperclass();

		if (pclz != null && !pclz.isInterface()) {

			Map<String, Field> fds1 = getObjectAllFieldsMap(pclz);
			if (fds1 != null && !fds1.isEmpty()) {
				fields.putAll(fds1);
			}
		}

		return fields;

	}

	public static String getModelTable(Class<?> clz) {
		final Table table = clz.getAnnotation(Table.class);
		if (table != null) {
			return table.value();
		}
		return StrKit.enCodeUnderlined(clz.getSimpleName());
	}

	public static String buildColumnsByExcluded(Class<?> clz, List<String> excludedColumns) {
		return buildColumnsByExcluded(clz, excludedColumns, false, null, null);
	}

	public static String buildMySQLColumnsByExcluded(Class<?> clz, List<String> excludedColumns) {
		return buildColumnsByExcluded(clz, excludedColumns, true, "`", "`");
	}

	public static String buildOracleColumnsByExcluded(Class<?> clz, List<String> excludedColumns) {

		String preEscape = "\"";
		String postEscape = "\"";

		ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
		Map<String, String> attrs = mf.getRawAttrMapping();
		Set<String> columns = new HashSet<String>();
		Set<Entry<String, String>> kvsets = attrs.entrySet();
		for (Entry<String, String> entry : kvsets) {
			if (excludedColumns.contains(entry.getKey()) || excludedColumns.contains(entry.getValue())
					|| excludedColumns.contains(entry.getValue().toLowerCase())) {
				continue;
			}

			columns.add(preEscape + entry.getValue().toUpperCase() + postEscape);
		}

		StringBuilder sb = new StringBuilder();
		columns.forEach(k -> sb.append(k).append(","));
		if (sb.length() > 0) {
			sb.deleteCharAt(sb.length() - 1);
		}
		return sb.toString();
	}

	public static String buildColumnsByExcluded(Class<?> clz, List<String> excludedColumns, boolean useSymbol,
			String preEscape, String postEscape) {

		ModelFabric mf = ModelCacheUtil.getModelFabric(clz);
		Map<String, String> attrs = mf.getRawAttrMapping();
		Set<String> columns = new HashSet<String>();
		Set<Entry<String, String>> kvsets = attrs.entrySet();
		for (Entry<String, String> entry : kvsets) {
			if (excludedColumns.contains(entry.getKey()) || excludedColumns.contains(entry.getValue())
					|| excludedColumns.contains(entry.getValue().toLowerCase())) {
				continue;
			}

			if (useSymbol) {
				columns.add(preEscape + entry.getValue() + postEscape);
			} else {
				columns.add(entry.getValue().toUpperCase());
			}
		}

		StringBuilder sb = new StringBuilder();
		columns.forEach(k -> sb.append(k).append(","));
		if (sb.length() > 0) {
			sb.deleteCharAt(sb.length() - 1);
		}
		return sb.toString();
	}
}
