package cn.sylinx.horm.dialect.fs.builder;

import cn.sylinx.horm.dialect.fs.FS;

class MySqlFSBuilder implements FSBuilder {

	@Override
	public <T> FS<T> build(Class<T> modelClass) {
		return MySqlFS.of(modelClass);
	}

	@Override
	public <T> FS<T> build(Class<T> modelClass, String tablePostfix) {
		return MySqlFS.of(modelClass, tablePostfix);
	}

	@Override
	public <T> FS<T> build(String tablePrefix, Class<T> modelClass) {
		return MySqlFS.of(tablePrefix, modelClass);
	}

	@Override
	public <T> FS<T> build(String tablePrefix, Class<T> modelClass, String tablePostfix) {
		return MySqlFS.of(tablePrefix, modelClass, tablePostfix);
	}

}
