package cn.sylinx.horm.dialect;

import cn.sylinx.horm.dialect.fs.builder.FSBuilder;
import cn.sylinx.horm.dialect.fs.builder.FSBuilderFactory;
import cn.sylinx.horm.dialect.sql.SqlBuilder;
import cn.sylinx.horm.dialect.sql.SqlBuilderFactory;
import cn.sylinx.horm.dialect.type.TypeHandlerBuilder;
import cn.sylinx.horm.dialect.type.TypeHandlerBuilderFactory;
import cn.sylinx.horm.type.handler.TypeHandler;

public interface Dialect {

	/**
	 * 数据库类型
	 * 
	 * @return
	 */
	DbType getDbType();

	/**
	 * sql 创建器
	 * 
	 * @return
	 */
	default SqlBuilder getSqlBuilder() {
		return SqlBuilderFactory.get().getSqlBuilder(getDbType());
	}

	/**
	 * fs 创建器
	 * 
	 * @return
	 */
	default FSBuilder getFSBuilder() {
		return FSBuilderFactory.get().getFSBuilder(getDbType());
	}

	/**
	 * 获取类型处理器
	 * 
	 * @param clazz
	 * @return
	 */
	default <T> TypeHandler<T> crateTypeHandler(Class<T> clazz) {
		TypeHandlerBuilder thb = getTypeHandlerBuilder();
		return thb == null ? null : thb.getTypeHandler(clazz);
	}

	/**
	 * 获取类型处理器构造者
	 * 
	 * @return
	 */
	default TypeHandlerBuilder getTypeHandlerBuilder() {
		return TypeHandlerBuilderFactory.get().getTypeHandlerBuilder(getDbType());
	}
}
