package cn.sylinx.horm.core.datasource;

import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

import cn.sylinx.horm.core.DynamicClient;
import cn.sylinx.horm.dialect.DbType;

public class NamedDataSource {
	private DataSource dataSource;
	private String dataSourceName;
	private DbType dbType;

	public NamedDataSource() {
		this.dataSourceName = DynamicClient.DEFAULT_DS_NAME;
	}

	public Connection getConnection() throws SQLException {
		return dataSource.getConnection();
	}

	public DataSource getDataSource() {
		return dataSource;
	}

	public void setDataSource(DataSource dataSource) {
		this.dataSource = dataSource;
	}

	public String getDataSourceName() {
		return dataSourceName;
	}

	public void setDataSourceName(String dataSourceName) {
		this.dataSourceName = dataSourceName;
	}

	public DbType getDbType() {
		return dbType;
	}

	public void setDbType(DbType dbType) {
		this.dbType = dbType;
	}

	public static NamedDataSource create(DataSource dataSource, String dataSourceName, DbType dbType) {
		NamedDataSource nds = new NamedDataSource();
		nds.setDataSource(dataSource);
		nds.setDataSourceName(dataSourceName);
		nds.setDbType(dbType);
		return nds;
	}

	@Override
	public String toString() {
		return "NamedDataSource [dataSource=" + dataSource + ", dataSourceName=" + dataSourceName + ", dbType=" + dbType
				+ "]";
	}
	
	
}