package cn.sylinx.horm.core.common;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import cn.sylinx.horm.dialect.Dialect;
import cn.sylinx.horm.type.TypeHandlerRegistry;
import cn.sylinx.horm.type.handler.TypeHandler;

/**
 * ORM通用工具
 * 
 * @author johnhan
 *
 */
@SuppressWarnings("unchecked")
public class OrmUtil {

    public static void setParameter(Dialect dialect, PreparedStatement pst, int index, Object param)
            throws SQLException {

        TypeHandler<Object> handler = null;
        Object actuallyParameter = null;

        if (param == null) {
            handler = TypeHandlerRegistry.getInstance().getUnknownTypeHandler();
        } else if (param instanceof TypedParameter) {
            TypedParameter typedParam = (TypedParameter) param;
            handler = getTypeHandler(dialect, (Class<Object>) typedParam.getParameterType());
            actuallyParameter = typedParam.getParameter();
        } else {
            handler = getTypeHandler(dialect, (Class<Object>) param.getClass());
            actuallyParameter = param;
        }

        if (handler != null) {
            handler.setParameter(pst, index, actuallyParameter);
        } else {
            pst.setObject(index, actuallyParameter);
        }
    }

    public static <T> T getResult(Dialect dialect, ResultSet rs, String columnName, Class<T> clz) throws SQLException {
        TypeHandler<T> handler = getTypeHandler(dialect, clz);
        if (handler != null) {
            return handler.getResult(rs, columnName);
        }
        return (T) rs.getObject(columnName);
    }

    public static <T> T getResult(Dialect dialect, ResultSet rs, int columnIndex, Class<T> clz) throws SQLException {
        TypeHandler<T> handler = getTypeHandler(dialect, clz);

        if (handler != null) {
            return handler.getResult(rs, columnIndex);
        }
        return (T) rs.getObject(columnIndex);
    }

    public static <T> T getResult(Dialect dialect, CallableStatement cs, int columnIndex, Class<T> clz)
            throws SQLException {

        TypeHandler<T> handler = getTypeHandler(dialect, clz);

        if (handler != null) {
            return handler.getResult(cs, columnIndex);
        }

        return (T) cs.getObject(columnIndex);
    }

    private static <T> TypeHandler<T> getTypeHandler(Dialect dialect, Class<T> clz) {
        TypeHandler<T> handlerDialect = (dialect == null ? null : dialect.crateTypeHandler(clz));
        if (handlerDialect == null) {
            handlerDialect = TypeHandlerRegistry.getInstance().getTypeHandler(clz);
        }
        return handlerDialect;
    }
}
