/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.type.handler;

import cn.sylinx.horm.type.handler.BaseTypeHandler;
import cn.sylinx.horm.type.handler.JdbcType;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.OffsetTime;

public class OffsetTimeTypeHandler
extends BaseTypeHandler<OffsetTime> {
    @Override
    protected JdbcType getJdbcType() {
        return JdbcType.TIME;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, OffsetTime parameter, JdbcType jdbcType) throws SQLException {
        ps.setTime(i, Time.valueOf(parameter.toLocalTime()));
    }

    @Override
    public OffsetTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Time time = rs.getTime(columnName);
        return OffsetTimeTypeHandler.getOffsetTime(time);
    }

    @Override
    public OffsetTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Time time = rs.getTime(columnIndex);
        return OffsetTimeTypeHandler.getOffsetTime(time);
    }

    @Override
    public OffsetTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Time time = cs.getTime(columnIndex);
        return OffsetTimeTypeHandler.getOffsetTime(time);
    }

    private static OffsetTime getOffsetTime(Time time) {
        if (time != null) {
            return time.toLocalTime().atOffset(OffsetTime.now().getOffset());
        }
        return null;
    }
}

