/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.type.handler;

import cn.sylinx.horm.type.handler.BaseTypeHandler;
import cn.sylinx.horm.type.handler.ByteArrayUtils;
import cn.sylinx.horm.type.handler.JdbcType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BlobByteObjectArrayTypeHandler
extends BaseTypeHandler<Byte[]> {
    @Override
    protected JdbcType getJdbcType() {
        return JdbcType.BLOB;
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Byte[] parameter, JdbcType jdbcType) throws SQLException {
        ByteArrayInputStream bis = new ByteArrayInputStream(ByteArrayUtils.convertToPrimitiveArray(parameter));
        ps.setBinaryStream(i, (InputStream)bis, parameter.length);
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Blob blob = rs.getBlob(columnName);
        return this.getBytes(blob);
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Blob blob = rs.getBlob(columnIndex);
        return this.getBytes(blob);
    }

    @Override
    public Byte[] getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Blob blob = cs.getBlob(columnIndex);
        return this.getBytes(blob);
    }

    private Byte[] getBytes(Blob blob) throws SQLException {
        Byte[] returnValue = null;
        if (blob != null) {
            returnValue = ByteArrayUtils.convertToObjectArray(blob.getBytes(1L, (int)blob.length()));
        }
        return returnValue;
    }
}

