/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.type.handler;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.type.handler.JdbcType;
import cn.sylinx.horm.type.handler.TypeHandler;
import cn.sylinx.horm.type.handler.TypeReference;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseTypeHandler<T>
extends TypeReference<T>
implements TypeHandler<T> {
    protected abstract JdbcType getJdbcType();

    @Override
    public void setParameter(PreparedStatement ps, int i, T parameter) throws SQLException {
        if (parameter == null) {
            try {
                ps.setNull(i, JdbcType.OTHER.TYPE_CODE);
            }
            catch (SQLException e) {
                ps.setObject(i, null);
            }
        } else {
            JdbcType jdbcType = this.getJdbcType();
            try {
                this.setNonNullParameter(ps, i, parameter, jdbcType);
            }
            catch (Exception e) {
                throw new HORMException("Error setting non null for parameter #" + i + " with JdbcType " + (Object)((Object)jdbcType) + " . Try setting a different JdbcType for this parameter or a different configuration property. Cause: " + e, e);
            }
        }
    }

    @Override
    public T getResult(ResultSet rs, String columnName) throws SQLException {
        T result;
        try {
            result = this.getNullableResult(rs, columnName);
        }
        catch (Exception e) {
            throw new HORMException("Error attempting to get column '" + columnName + "' from result set.  Cause: " + e, e);
        }
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    @Override
    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        T result;
        try {
            result = this.getNullableResult(rs, columnIndex);
        }
        catch (Exception e) {
            throw new HORMException("Error attempting to get column #" + columnIndex + " from result set.  Cause: " + e, e);
        }
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    @Override
    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        T result;
        try {
            result = this.getNullableResult(cs, columnIndex);
        }
        catch (Exception e) {
            throw new HORMException("Error attempting to get column #" + columnIndex + " from callable statement.  Cause: " + e, e);
        }
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }

    public abstract void setNonNullParameter(PreparedStatement var1, int var2, T var3, JdbcType var4) throws SQLException;

    public abstract T getNullableResult(ResultSet var1, String var2) throws SQLException;

    public abstract T getNullableResult(ResultSet var1, int var2) throws SQLException;

    public abstract T getNullableResult(CallableStatement var1, int var2) throws SQLException;
}

