/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.spring.scan;

import cn.sylinx.horm.model.anno.Model;
import cn.sylinx.horm.spring.scan.ClassPathModelScanner;
import cn.sylinx.horm.util.GLog;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class ModelScannerRegistrar
implements ImportBeanDefinitionRegistrar,
ResourceLoaderAware,
EnvironmentAware {
    private ResourceLoader resourceLoader;
    private List<String> packages;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        GLog.info("Starting ModelScannerRegistrar at:{}", new Date());
        Boolean cacheModelOnStart = (Boolean)this.environment.getProperty("hrom.config.cache-model-on-start", Boolean.class, (Object)false);
        if (!cacheModelOnStart.booleanValue()) {
            GLog.info("hrom.config.cache-model-on-start=false\uff0c\u65e0\u9700\u626b\u63cf@Model", new Object[0]);
            return;
        }
        Boolean debug = (Boolean)this.environment.getProperty("horm.config.debug", Boolean.class, (Object)false);
        if (debug.booleanValue()) {
            GLog.info("\u8c03\u8bd5\u73af\u5883\u65e0\u9700\u626b\u63cf@Model", new Object[0]);
            return;
        }
        GLog.debug("Searching for model annotated with @Model", new Object[0]);
        ClassPathModelScanner scanner = new ClassPathModelScanner(registry);
        try {
            if (this.resourceLoader != null) {
                scanner.setResourceLoader(this.resourceLoader);
            }
            scanner.setAnnotationClass(Model.class);
            scanner.registerFilters();
            scanner.doScan(StringUtils.toStringArray(this.getPackages()));
        }
        catch (IllegalStateException ex) {
            GLog.debug("Could not determine auto-configuration package, automatic model scanning disabled.", ex);
        }
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

