/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.spring.scan;

import cn.sylinx.horm.proxy.mapper.parse.NamespaceContainer;
import cn.sylinx.horm.proxy.mapper.registrar.MapperRegistrar;
import cn.sylinx.horm.spring.scan.MapperFactoryBean;
import cn.sylinx.horm.util.GLog;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public class MapperScannerRegistrar
implements ImportBeanDefinitionRegistrar {
    private List<String> packages;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        GLog.info("Starting MapperScannerRegistrar at:{}", new Date());
        GLog.debug("Searching for Mapper ...", new Object[0]);
        List<String> pkgs = this.getPackages();
        for (String pkg : pkgs) {
            MapperRegistrar.create().register(pkg);
        }
        List<Class<?>> maperClass = NamespaceContainer.getAllMapperClass();
        maperClass.forEach(c -> this.registerBean((Class<?>)c, registry));
    }

    private void registerBean(Class<?> maperClass, BeanDefinitionRegistry registry) {
        GLog.debug("\u6ce8\u518c Mapper -->> {}", maperClass.getName());
        GenericBeanDefinition definition = new GenericBeanDefinition();
        definition.getConstructorArgumentValues().addGenericArgumentValue((Object)maperClass.getName());
        definition.setBeanClass(MapperFactoryBean.class);
        definition.setAutowireMode(2);
        registry.registerBeanDefinition(maperClass.getName(), (BeanDefinition)definition);
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }
}

