/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.spring.scan;

import cn.sylinx.horm.proxy.ProxyObjectRegistry;
import cn.sylinx.horm.spring.scan.CommandFactoryBean;
import cn.sylinx.horm.util.GLog;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathCommandScanner
extends ClassPathBeanDefinitionScanner {
    private Class<? extends Annotation> annotationClass;
    private Class<?> markerInterface;
    private CommandFactoryBean<?> commandFactoryBean = new CommandFactoryBean();

    public ClassPathCommandScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public void setCommandFactoryBean(CommandFactoryBean<?> commandFactoryBean) {
        this.commandFactoryBean = commandFactoryBean;
    }

    public void setAnnotationClass(Class<? extends Annotation> annotationClass) {
        this.annotationClass = annotationClass;
    }

    public void setMarkerInterface(Class<?> markerInterface) {
        this.markerInterface = markerInterface;
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            GLog.warn("No horm command was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration.", new Object[0]);
        } else {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) {
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        GLog.warn("Skipping CommandFactoryBean with name '" + beanName + "' and '" + beanDefinition.getBeanClassName() + "' commandInterface. Bean already defined with the same name!", new Object[0]);
        return false;
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            GLog.debug("Creating CommandFactoryBean with name '" + holder.getBeanName() + "' and '" + definition.getBeanClassName() + "' commandInterface", new Object[0]);
            String className = definition.getBeanClassName();
            definition.getConstructorArgumentValues().addGenericArgumentValue((Object)className);
            definition.setBeanClass(this.commandFactoryBean.getClass());
            definition.setAutowireMode(2);
            ProxyObjectRegistry.INSTANCE.register(className);
        }
    }

    public void registerFilters() {
        boolean acceptAllInterfaces = true;
        if (this.annotationClass != null) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.annotationClass));
            acceptAllInterfaces = false;
        }
        if (this.markerInterface != null) {
            this.addIncludeFilter((TypeFilter)new AssignableTypeFilter(this.markerInterface){

                protected boolean matchClassName(String className) {
                    return false;
                }
            });
            acceptAllInterfaces = false;
        }
        if (acceptAllInterfaces) {
            this.addIncludeFilter(new TypeFilter(){

                public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                    return true;
                }
            });
        }
        this.addExcludeFilter(new TypeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                String className = metadataReader.getClassMetadata().getClassName();
                return className.endsWith("package-info");
            }
        });
    }
}

