/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.spring.boot;

import cn.sylinx.horm.core.OrmClient;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.core.TransactionSupportOrmClient;
import cn.sylinx.horm.core.datasource.ConnectionProvider;
import cn.sylinx.horm.core.datasource.NamedDataSource;
import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.dialect.DialectFactory;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.parse.SqlParser;
import cn.sylinx.horm.spring.boot.HORMBootConfig;
import cn.sylinx.horm.spring.config.DataSourceConfig;
import cn.sylinx.horm.spring.config.SingleDataSourceConfig;
import cn.sylinx.horm.transaction.jdbc.JdbcTransactionalConnectionProvider;
import cn.sylinx.horm.transaction.spring.SpringDataSourceConnectionProvider;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

class SqlClientInitBySpring {
    private HORMBootConfig bootConfig;
    private ApplicationContext applicationContext;

    SqlClientInitBySpring() {
    }

    public SqlClient create() {
        return this.parseSpringDatasource(this.bootConfig);
    }

    public SqlClientInitBySpring setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        return this;
    }

    public SqlClientInitBySpring setBootConfig(HORMBootConfig bootConfig) {
        this.bootConfig = bootConfig;
        return this;
    }

    private SqlClient parseSpringDatasource(HORMBootConfig bootConfig) {
        SqlClient sqlClient = null;
        if (this.isSingle(bootConfig)) {
            GLog.debug("\u521d\u59cb\u5316\u5355\u6570\u636e\u6e90 by spring", new Object[0]);
            sqlClient = this.getSingleSqlClient(bootConfig);
        } else {
            GLog.debug("\u521d\u59cb\u5316\u591a\u6570\u636e\u6e90 by spring", new Object[0]);
            sqlClient = this.getMultiSqlClient(bootConfig);
        }
        return sqlClient;
    }

    private SqlClient getSingleSqlClient(HORMBootConfig bootConfig, String dbtype, String qualifier, String dataSourceName) {
        DataSource dataSource;
        DbType dbTypeEnum = DbType.getDbType(dbtype);
        DataSource dataSource2 = dataSource = StrKit.isBlank(qualifier) ? (DataSource)this.applicationContext.getBean(DataSource.class) : (DataSource)this.applicationContext.getBean(qualifier, DataSource.class);
        if (dataSource == null) {
            GLog.error(StrKit.isBlank(qualifier) ? "Default DataSource NOT FOUND" : "DataSource NOT FOUND, qualifier:{}", qualifier);
            throw new HORMException("DataSource NOT FOUND");
        }
        NamedDataSource namedDataSource = new NamedDataSource();
        namedDataSource.setDataSource(dataSource);
        namedDataSource.setDbType(dbTypeEnum);
        namedDataSource.setDataSourceName(dataSourceName);
        OrmClient sqlClient = this.getSqlClient(bootConfig);
        sqlClient.setConnectionProvider(this.getConnectionProvider(bootConfig, namedDataSource));
        sqlClient.setDialect(DialectFactory.createDialect(dbtype));
        sqlClient.setSqlParser(this.getSqlParser(bootConfig, dbTypeEnum));
        return sqlClient;
    }

    private SqlClient initOneDatasource(HORMBootConfig bootConfig, SingleDataSourceConfig singleDataSourceConfig) {
        return this.getSingleSqlClient(bootConfig, singleDataSourceConfig.getDbtype(), singleDataSourceConfig.getName(), singleDataSourceConfig.getName());
    }

    private boolean isSingle(HORMBootConfig bootConfig) {
        DataSourceConfig dataSourceConfig = bootConfig.getDatasource();
        if (dataSourceConfig == null) {
            throw new HORMException("\u6570\u636e\u6e90\u914d\u7f6e\u4e22\u5931");
        }
        return !dataSourceConfig.isMultiple();
    }

    private ConnectionProvider getConnectionProvider(HORMBootConfig bootConfig, NamedDataSource namedDataSource) {
        return bootConfig.isTransactionNative() ? new JdbcTransactionalConnectionProvider(namedDataSource) : new SpringDataSourceConnectionProvider(namedDataSource);
    }

    private OrmClient getSqlClient(HORMBootConfig bootConfig) {
        return bootConfig.isTransactionNative() ? new TransactionSupportOrmClient() : new OrmClient();
    }

    private SqlParser getSqlParser(HORMBootConfig bootConfig, DbType dbTypeEnum) {
        return new SqlParser(bootConfig.isParseSqlPathDbtype() ? dbTypeEnum : null);
    }

    private SqlClient getSingleSqlClient(HORMBootConfig bootConfig) {
        return this.getSingleSqlClient(bootConfig, bootConfig.getDatasource().getDefaultDbtype(), null, "_DEFAULT_DS_NAME_FOR_HORM_");
    }

    private SqlClient getMultiSqlClient(HORMBootConfig bootConfig) {
        List<SingleDataSourceConfig> multids = bootConfig.getDatasource().getMultids();
        if (multids == null || multids.isEmpty()) {
            throw new HORMException("\u591a\u6570\u636e\u6e90\u521d\u59cb\u5316\u5f02\u5e38");
        }
        ArrayList<SqlClient> sqlClientList = new ArrayList<SqlClient>();
        SqlClient defaultSqlClient = null;
        for (SingleDataSourceConfig c : multids) {
            SqlClient sqlClientOne = this.initOneDatasource(bootConfig, c);
            sqlClientList.add(sqlClientOne);
            if (c.getPrimary() == null || !c.getPrimary().booleanValue()) continue;
            defaultSqlClient = sqlClientOne;
        }
        if (defaultSqlClient == null) {
            defaultSqlClient = (SqlClient)sqlClientList.get(0);
        }
        return defaultSqlClient;
    }
}

