/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.spring.boot;

import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.core.TransactionSupportOrmClient;
import cn.sylinx.horm.core.datasource.NamedDataSource;
import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.dialect.DialectFactory;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.pool.DataSourceWrapperFactory;
import cn.sylinx.horm.resource.parse.SqlParser;
import cn.sylinx.horm.spring.boot.HORMBootConfig;
import cn.sylinx.horm.spring.config.DataSourceConfig;
import cn.sylinx.horm.spring.config.SingleDataSourceConfig;
import cn.sylinx.horm.starter.CommonStarter;
import cn.sylinx.horm.transaction.jdbc.JdbcTransactionalConnectionProvider;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.StrKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class SqlClientInitByNative {
    private HORMBootConfig bootConfig;

    SqlClientInitByNative() {
    }

    public SqlClient create() {
        this.initSqlClient(this.parseDataSource());
        return SqlClient.getDefaultClient();
    }

    public SqlClientInitByNative setBootConfig(HORMBootConfig bootConfig) {
        this.bootConfig = bootConfig;
        return this;
    }

    private boolean isMultiple() {
        return this.bootConfig.getDatasource().isMultiple();
    }

    private SqlParser getSqlParser(DbType dbTypeEnum) {
        return new SqlParser(this.bootConfig.isParseSqlPathDbtype() ? dbTypeEnum : null);
    }

    private List<NamedDataSource> parseDataSource() {
        ArrayList<NamedDataSource> dataSourceList = new ArrayList<NamedDataSource>();
        if (!this.isMultiple()) {
            dataSourceList.add(this.checkAndGetSingleNamedDataSource());
        } else {
            dataSourceList.addAll(this.checkAndGetMultiNamedDataSource());
        }
        return dataSourceList;
    }

    private List<NamedDataSource> checkAndGetMultiNamedDataSource() {
        HashSet<String> nameUnique = new HashSet<String>(8);
        ArrayList<NamedDataSource> dsList = new ArrayList<NamedDataSource>();
        DataSourceConfig datasource = this.bootConfig.getDatasource();
        List<SingleDataSourceConfig> multids = datasource.getMultids();
        if (multids == null || multids.isEmpty()) {
            throw new HORMException("\u8bf7\u8bbe\u7f6e\u6700\u5c11\u4e00\u4e2a\u6570\u636e\u6e90");
        }
        for (int i = 0; i < multids.size(); ++i) {
            SingleDataSourceConfig sds = multids.get(i);
            NamedDataSource nds = this.checkAndGetOneNamedDataSource(multids.get(i));
            if (nameUnique.contains(nds.getDataSourceName())) {
                throw new HORMException("datasource name should be unique");
            }
            nameUnique.add(nds.getDataSourceName());
            CommonStarter.NamedDataSourcePrimary ndsp = this.toNamedDataSourcePrimary(nds, sds.getPrimary());
            dsList.add(ndsp);
        }
        return dsList;
    }

    private CommonStarter.NamedDataSourcePrimary toNamedDataSourcePrimary(NamedDataSource nds, boolean isPrimary) {
        CommonStarter.NamedDataSourcePrimary ndsp = new CommonStarter.NamedDataSourcePrimary();
        ndsp.setDataSource(nds.getDataSource());
        ndsp.setDataSourceName(nds.getDataSourceName());
        ndsp.setDbType(nds.getDbType());
        ndsp.setPrimary(isPrimary);
        return ndsp;
    }

    private NamedDataSource checkAndGetSingleNamedDataSource() {
        DataSourceConfig dataSourceConfig = this.bootConfig.getDatasource();
        SingleDataSourceConfig singleDataSourceConfig = new SingleDataSourceConfig();
        singleDataSourceConfig.setDbtype(dataSourceConfig.getDefaultDbtype());
        singleDataSourceConfig.setDriver(dataSourceConfig.getDefaultDriver());
        singleDataSourceConfig.setName("_DEFAULT_DS_NAME_FOR_HORM_");
        singleDataSourceConfig.setPassword(dataSourceConfig.getDefaultPassword());
        singleDataSourceConfig.setPoolConfig(dataSourceConfig.getDefaultPoolConfig());
        singleDataSourceConfig.setPooltype(dataSourceConfig.getDefaultPooltype());
        singleDataSourceConfig.setPrimary(true);
        singleDataSourceConfig.setUrl(dataSourceConfig.getDefaultUrl());
        singleDataSourceConfig.setUsername(dataSourceConfig.getDefaultUsername());
        return this.checkAndGetOneNamedDataSource(singleDataSourceConfig);
    }

    private NamedDataSource checkAndGetOneNamedDataSource(SingleDataSourceConfig singleDataSourceConfig) {
        String url = singleDataSourceConfig.getUrl();
        String driver = singleDataSourceConfig.getDriver();
        String dbtype = singleDataSourceConfig.getDbtype();
        if (StrKit.isBlank(url) || StrKit.isBlank(driver) || StrKit.isBlank(dbtype)) {
            throw new HORMException("\u6570\u636e\u6e90\u53c2\u6570\u914d\u7f6e\u4e22\u5931");
        }
        DbType dbTypeEnum = DbType.getDbType(dbtype);
        GLog.debug("Use DbType:{}", dbTypeEnum.getValue());
        String pooltype = singleDataSourceConfig.getPooltype();
        String username = singleDataSourceConfig.getUsername();
        String password = singleDataSourceConfig.getPassword();
        String name = singleDataSourceConfig.getName();
        HashMap<String, Object> dsMap = new HashMap<String, Object>();
        dsMap.put("dbtype", dbtype);
        dsMap.put("pooltype", pooltype);
        dsMap.put("name", name);
        dsMap.put("url", url);
        dsMap.put("driver", driver);
        dsMap.put("username", username);
        dsMap.put("password", password);
        Map<String, Object> extConfig = singleDataSourceConfig.getPoolConfig();
        NamedDataSource namedDataSource = DataSourceWrapperFactory.buildDataSource(dsMap, extConfig);
        return namedDataSource;
    }

    private void initOneSqlClient(NamedDataSource signleNamedDataSource) {
        TransactionSupportOrmClient ormClient = new TransactionSupportOrmClient();
        ormClient.setDialect(DialectFactory.createDialect(signleNamedDataSource.getDbType()));
        ormClient.setSqlParser(this.getSqlParser(signleNamedDataSource.getDbType()));
        ormClient.setConnectionProvider(new JdbcTransactionalConnectionProvider(signleNamedDataSource));
    }

    private void initSqlClient(List<NamedDataSource> dataSourceList) {
        if (dataSourceList == null || dataSourceList.isEmpty()) {
            throw new HORMException("\u6570\u636e\u6e90\u4fe1\u606f\u4e22\u5931");
        }
        if (!this.isMultiple()) {
            GLog.debug("\u521d\u59cb\u5316\u5355\u6570\u636e\u6e90 by HORM", new Object[0]);
            this.initOneSqlClient(dataSourceList.get(0));
        } else {
            GLog.debug("\u521d\u59cb\u5316\u591a\u6570\u636e\u6e90 by HORM", new Object[0]);
            ArrayList<CommonStarter.NamedDataSourcePrimary> transferdNdsp = new ArrayList<CommonStarter.NamedDataSourcePrimary>();
            int primaryMult = 0;
            CommonStarter.NamedDataSourcePrimary primaryed = null;
            for (NamedDataSource namedDataSource : dataSourceList) {
                CommonStarter.NamedDataSourcePrimary ndsp = (CommonStarter.NamedDataSourcePrimary)namedDataSource;
                if (ndsp.isPrimary()) {
                    primaryed = ndsp;
                    ++primaryMult;
                }
                if (primaryMult > 1) {
                    throw new HORMException("primary datasource should be only one!");
                }
                transferdNdsp.add(ndsp);
            }
            CommonStarter.NamedDataSourcePrimary primaryJumpQueue = null;
            if (primaryed == null) {
                primaryed = (CommonStarter.NamedDataSourcePrimary)transferdNdsp.get(0);
            }
            primaryJumpQueue = new CommonStarter.NamedDataSourcePrimary();
            primaryJumpQueue.setDataSource(primaryed.getDataSource());
            primaryJumpQueue.setDataSourceName("_DEFAULT_DS_NAME_FOR_HORM_");
            primaryJumpQueue.setDbType(primaryed.getDbType());
            primaryJumpQueue.setPrimary(true);
            GLog.info("default SqlClient --> [" + primaryed.getDataSourceName() + "]", new Object[0]);
            transferdNdsp.add(primaryJumpQueue);
            transferdNdsp.forEach(this::initOneSqlClient);
        }
    }
}

