/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.spring.boot;

import cn.sylinx.horm.config.OrmConfigHolder;
import cn.sylinx.horm.config.ServiceEnvironment;
import cn.sylinx.horm.core.SqlClient;
import cn.sylinx.horm.spring.boot.AutoConfiguredCommandScannerRegistrar;
import cn.sylinx.horm.spring.boot.AutoConfiguredMapperScannerRegistrar;
import cn.sylinx.horm.spring.boot.AutoConfiguredModelScannerRegistrar;
import cn.sylinx.horm.spring.boot.HORMBootConfig;
import cn.sylinx.horm.spring.boot.SqlClientInitByNative;
import cn.sylinx.horm.spring.boot.SqlClientInitBySpring;
import cn.sylinx.horm.util.GLog;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@ConditionalOnClass(value={DataSource.class})
@EnableConfigurationProperties(value={HORMBootConfig.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class HORMAutoConfiguration {

    @Configuration
    @Conditional(value={SqlClientUseSpringCondition.class})
    @ConditionalOnBean(value={DataSource.class})
    @Import(value={AutoConfiguredCommandScannerRegistrar.class, AutoConfiguredModelScannerRegistrar.class, AutoConfiguredMapperScannerRegistrar.class})
    static class SqlClientInSpringAutoConfiguration
    implements ApplicationContextAware {
        private ApplicationContext applicationContext;

        SqlClientInSpringAutoConfiguration() {
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        @Bean
        @ConditionalOnMissingBean
        public SqlClient sqlClient(HORMBootConfig bootConfig) {
            GLog.debug("SqlClient[UseSpring] inited begin..", new Object[0]);
            SqlClient sqlClient = new SqlClientInitBySpring().setApplicationContext(this.applicationContext).setBootConfig(bootConfig).create();
            OrmConfigHolder.init(ServiceEnvironment.SPRINGBOOT, bootConfig);
            GLog.info("SqlClient[UseSpring] inited done", new Object[0]);
            return sqlClient;
        }
    }

    @Configuration
    @Conditional(value={SqlClientUseNativeCondition.class})
    @Import(value={AutoConfiguredCommandScannerRegistrar.class, AutoConfiguredModelScannerRegistrar.class, AutoConfiguredMapperScannerRegistrar.class})
    static class SqlClientUseNativeAutoConfiguration {
        SqlClientUseNativeAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SqlClient sqlClientUseNative(HORMBootConfig bootConfig) {
            GLog.debug("SqlClient[UseNative] inited begin..", new Object[0]);
            SqlClient sqlClient = new SqlClientInitByNative().setBootConfig(bootConfig).create();
            OrmConfigHolder.init(ServiceEnvironment.SPRINGBOOT, bootConfig);
            GLog.info("SqlClient[UseNative] inited done", new Object[0]);
            return sqlClient;
        }
    }

    static class SqlClientUseNativeCondition
    implements Condition {
        SqlClientUseNativeCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String type = context.getEnvironment().getProperty("horm.config.datasource.use-native", "false");
            String type1 = context.getEnvironment().getProperty("horm.config.datasource.useNative", "false");
            return Boolean.valueOf(type) != false || Boolean.valueOf(type1) != false;
        }
    }

    static class SqlClientUseSpringCondition
    implements Condition {
        SqlClientUseSpringCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !new SqlClientUseNativeCondition().matches(context, metadata);
        }
    }
}

