/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.parse;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.ClasspathSqlResource;
import cn.sylinx.horm.resource.ClasspathSqlResourceManager;
import cn.sylinx.horm.resource.StatementHandler;
import cn.sylinx.horm.resource.parse.GenericTokenParser;
import cn.sylinx.horm.resource.parse.TokenHandler;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.StrKit;
import java.util.Map;

public class SqlParser {
    public static final String SQL_POSTFIX = ".sql";
    private DbType dbtype;

    public SqlParser() {
    }

    public SqlParser(DbType dbtype) {
        this.dbtype = dbtype;
    }

    public DbType getDbtype() {
        return this.dbtype;
    }

    public void setDbtype(DbType dbtype) {
        this.dbtype = dbtype;
    }

    public Pair parseSql(ClasspathSqlResource sqlResource, Map<String, Object> params) {
        String statement = ClasspathSqlResourceManager.getStatement(this.parseTruelySqlpath(sqlResource.getSqlpath()));
        if (StrKit.isBlank(statement)) {
            throw new HORMException("SQL\u8bed\u53e5\u4e3a\u7a7a, \u8d44\u6e90:" + sqlResource.getSqlpath());
        }
        return this.parseSql(statement, params, sqlResource.isFormat(), sqlResource.getStatementHandler());
    }

    protected String parseTruelySqlpath(String sqlpath) {
        if (this.dbtype == null) {
            return sqlpath;
        }
        String dbtypePostfix = "." + this.dbtype.getValue() + SQL_POSTFIX;
        int indexExist = sqlpath.lastIndexOf(dbtypePostfix);
        if (indexExist > 0) {
            return sqlpath;
        }
        int index = sqlpath.lastIndexOf(SQL_POSTFIX);
        if (index < 1) {
            throw new HORMException("invalid sql resource file");
        }
        return sqlpath.substring(0, index) + dbtypePostfix;
    }

    public Pair parseSql(String statement, Map<String, Object> params, StatementHandler sqlHandler) {
        return this.parseSql(statement, params, true, sqlHandler);
    }

    public Pair parseSql(String statement, Map<String, Object> params) {
        return this.parseSql(statement, params, null);
    }

    public Pair parseSql(String statement, Map<String, Object> params, boolean format, StatementHandler sqlHandler) {
        TokenHandler handler = this.createWithParameterMap(params);
        GenericTokenParser gt = new GenericTokenParser(handler);
        Pair tp = gt.parse(statement, format);
        if (sqlHandler != null) {
            String statementReplace = sqlHandler.handle(tp.getObject(0, String.class));
            GLog.debug("changed sql: " + statementReplace, new Object[0]);
            return Pair.apply((Object)statementReplace, tp.get(1));
        }
        return tp;
    }

    private TokenHandler createWithParameterMap(Map<String, Object> params) {
        TokenHandler handler = TokenHandler.create();
        handler.setParameterMap(params);
        return handler;
    }
}

