/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.io;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.resource.io.Resources;
import cn.sylinx.horm.util.StrKit;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class BaseResourceScanner {
    private final String packageName;
    private final String packageNameWithDot;
    private final String packageDirName;
    private final String packagePath;
    private final Set<Object> resources = new HashSet<Object>();

    public BaseResourceScanner() {
        this(null);
    }

    public BaseResourceScanner(String packageName) {
        this.packageName = packageName = this.nullToEmpty(packageName);
        this.packageNameWithDot = packageName.endsWith(".") ? packageName : packageName.concat(".");
        this.packageDirName = packageName.replace('.', File.separatorChar);
        this.packagePath = packageName.replace('.', '/');
    }

    public Set<Object> scan() {
        return this.scan(false);
    }

    private static Enumeration<URL> getResourceIter(String resource) {
        Enumeration<URL> resources;
        try {
            resources = Resources.getClassLoader().getResources(resource);
        }
        catch (IOException e) {
            throw new HORMException(e);
        }
        return resources;
    }

    public Set<Object> scan(boolean forceScanJavaClassPaths) {
        Enumeration<URL> eurls = BaseResourceScanner.getResourceIter(this.packagePath);
        while (eurls.hasMoreElements()) {
            URL url = eurls.nextElement();
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(url.getFile()), null);
                    break;
                }
                case "jar": {
                    this.scanJar(this.getJarFile(url));
                }
            }
        }
        if (forceScanJavaClassPaths || this.resources.isEmpty()) {
            this.scanJavaClassPaths();
        }
        return Collections.unmodifiableSet(this.resources);
    }

    private JarFile getJarFile(URL url) {
        try {
            JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
            return urlConnection.getJarFile();
        }
        catch (IOException e) {
            throw new HORMException(e);
        }
    }

    private void scanJavaClassPaths() {
        String[] javaClassPaths;
        for (String classPath : javaClassPaths = this.getJavaClassPaths()) {
            this.scanFile(new File(classPath), null);
        }
    }

    private String[] getJavaClassPaths() {
        return System.getProperty("java.class.path").split(System.getProperty("path.separator"));
    }

    protected abstract String getMatchedPostfix();

    protected boolean accept(String resoureName) {
        return true;
    }

    private void scanFile(File file, String rootDir) {
        File[] files;
        String postfix = this.getMatchedPostfix();
        int postfixLen = postfix.length();
        if (file.isFile()) {
            String fileName = file.getAbsolutePath();
            if (fileName.endsWith(postfix)) {
                String resourceName = fileName.substring(rootDir.length(), fileName.length() - postfixLen).replace(File.separatorChar, '.');
                this.addIfAccept(resourceName);
            } else if (fileName.endsWith(".jar")) {
                try {
                    this.scanJar(new JarFile(file));
                }
                catch (IOException e) {
                    throw new HORMException(e);
                }
            }
        } else if (file.isDirectory() && null != (files = file.listFiles())) {
            for (File subFile : files) {
                this.scanFile(subFile, null == rootDir ? this.subPathBeforePackage(file) : rootDir);
            }
        }
    }

    private void scanJar(JarFile jar) {
        String postfix = this.getMatchedPostfix();
        int postfixLen = postfix.length();
        Enumeration<JarEntry> jarEntrys = jar.entries();
        while (jarEntrys.hasMoreElements()) {
            JarEntry entry = jarEntrys.nextElement();
            String name = this.removePrefix(entry.getName(), "/");
            if (!this.isEmpty(this.packagePath) && !name.startsWith(this.packagePath) || !name.endsWith(postfix) || entry.isDirectory()) continue;
            String resourceName = name.substring(0, name.length() - postfixLen).replace('/', '.');
            this.addIfAccept(resourceName);
        }
    }

    private boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    private String removePrefix(String str, CharSequence prefix) {
        if (this.isEmpty(str) || this.isEmpty(prefix)) {
            return str;
        }
        String str2 = str.toString();
        if (str2.startsWith(prefix.toString())) {
            return this.subSuf(str2, prefix.length());
        }
        return str2;
    }

    private String subSuf(String string, int fromIndex) {
        if (this.isEmpty(string)) {
            return null;
        }
        return this.sub(string, fromIndex, string.length());
    }

    private String sub(String str, int fromIndexInclude, int toIndexExclude) {
        if (this.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        if (fromIndexInclude < 0) {
            if ((fromIndexInclude = len + fromIndexInclude) < 0) {
                fromIndexInclude = 0;
            }
        } else if (fromIndexInclude > len) {
            fromIndexInclude = len;
        }
        if (toIndexExclude < 0) {
            if ((toIndexExclude = len + toIndexExclude) < 0) {
                toIndexExclude = len;
            }
        } else if (toIndexExclude > len) {
            toIndexExclude = len;
        }
        if (toIndexExclude < fromIndexInclude) {
            int tmp = fromIndexInclude;
            fromIndexInclude = toIndexExclude;
            toIndexExclude = tmp;
        }
        if (fromIndexInclude == toIndexExclude) {
            return "";
        }
        return str.toString().substring(fromIndexInclude, toIndexExclude);
    }

    private void addIfAccept(String resoureName) {
        int packageLen;
        if (StrKit.isBlank(resoureName)) {
            return;
        }
        int resoureLen = resoureName.length();
        if (resoureLen == (packageLen = this.packageName.length())) {
            if (resoureName.equals(this.packageName)) {
                this.addIfAcceptByFilter(resoureName);
            }
        } else if (resoureLen > packageLen && (".".equals(this.packageNameWithDot) || resoureName.startsWith(this.packageNameWithDot))) {
            this.addIfAcceptByFilter(resoureName);
        }
    }

    private void addIfAcceptByFilter(String resoureName) {
        if (null != resoureName && this.accept(resoureName)) {
            this.resources.add(this.transform(resoureName));
        }
    }

    protected Object transform(String resoureName) {
        return resoureName;
    }

    private String subPathBeforePackage(File file) {
        String filePath = file.getAbsolutePath();
        if (this.isNotEmpty(this.packageDirName)) {
            filePath = this.subBefore(filePath, this.packageDirName, true);
        }
        if (filePath.endsWith(File.separator)) {
            return filePath;
        }
        return filePath.concat(File.separator);
    }

    private boolean isNotEmpty(String str) {
        return false == this.isEmpty(str);
    }

    private String subBefore(String str, String sep, boolean isLastSeparator) {
        int pos;
        if (this.isEmpty(str) || sep == null) {
            return null == str ? null : str;
        }
        if (sep.isEmpty()) {
            return "";
        }
        int n = pos = isLastSeparator ? str.lastIndexOf(sep) : str.indexOf(sep);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return "";
        }
        return str.substring(0, pos);
    }

    private String nullToEmpty(String str) {
        return str == null ? "" : str;
    }
}

