/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.resource.block;

import cn.sylinx.horm.resource.block.ELSE;
import cn.sylinx.horm.resource.block.ELSIF;
import cn.sylinx.horm.resource.block.END;
import cn.sylinx.horm.resource.block.FollowNode;
import cn.sylinx.horm.resource.block.IF;
import cn.sylinx.horm.resource.block.IfEndBlock;
import cn.sylinx.horm.resource.block.IfEndBlockParser;
import cn.sylinx.horm.resource.block.Node;
import cn.sylinx.horm.resource.block.Tags;
import cn.sylinx.horm.resource.parse.TokenHandler;
import cn.sylinx.horm.util.Tuple;
import java.util.List;
import java.util.Stack;

public class IfEndBlockParserImpl
implements IfEndBlockParser {
    private char keyword = (char)35;
    private Stack<Node> stack = new Stack();
    private StringBuilder sb = new StringBuilder();
    private IfEndBlock ifEndBlockForResult = null;
    private TokenHandler handler;

    public IfEndBlockParserImpl(TokenHandler handler) {
        this.handler = handler;
    }

    @Override
    public String parse(String statement) {
        this.stack.clear();
        this.sb.setLength(0);
        this.ifEndBlockForResult = null;
        IfEndBlock ifEndBlock = this.parseIfEndBlock(statement);
        return this.parseContent(statement, ifEndBlock);
    }

    private boolean preCheck(String kw) {
        return Tags.isSeeminglyKeyworld(kw);
    }

    private IfEndBlock parseIfEndBlock(String statement) {
        int len = statement.length();
        boolean meetKeyWord = false;
        String node = null;
        for (int i = 0; i < len; ++i) {
            char c = statement.charAt(i);
            if (this.keyword == c) {
                meetKeyWord = true;
                this.sb.append(c);
                continue;
            }
            if (!meetKeyWord) continue;
            this.sb.append(c);
            node = this.sb.toString();
            if (!this.preCheck(node)) {
                this.sb.setLength(0);
                meetKeyWord = false;
                continue;
            }
            if (node.startsWith("#FUNC")) {
                this.sb.setLength(0);
                meetKeyWord = false;
                continue;
            }
            if (node.startsWith("#{")) {
                this.sb.setLength(0);
                meetKeyWord = false;
                continue;
            }
            if (node.equals("#IF")) {
                this.withIf(statement, i);
                this.sb.setLength(0);
                meetKeyWord = false;
                continue;
            }
            if (node.equals("#ELSIF")) {
                this.withElsif(statement, i);
                this.sb.setLength(0);
                meetKeyWord = false;
                continue;
            }
            if (node.equals("#ELSE")) {
                this.withElse(statement, i);
                this.sb.setLength(0);
                meetKeyWord = false;
                continue;
            }
            if (!node.equals("#END")) continue;
            this.withEnd(statement, i);
            this.sb.setLength(0);
            meetKeyWord = false;
        }
        return this.stack.empty() ? this.ifEndBlockForResult : null;
    }

    private void withEnd(String statement, int index) {
        Node node = this.stack.peek();
        if (node == null) {
            throw new RuntimeException("end prenode not exist.");
        }
        END end = new END();
        end.setIndex(index);
        end.setNextIndex(index + 1);
        if (node instanceof IF) {
            IF ifnode = (IF)node;
            ifnode.setFollowNode(end);
            String contentPattern = statement.substring(ifnode.getNextIndex(), end.getIndex() - "#END".length() + 1);
            ifnode.setContentPattern(contentPattern);
            end.setPreNode(ifnode);
        } else if (node instanceof ELSIF) {
            ELSIF preElsif = (ELSIF)node;
            preElsif.setFollowNode(end);
            String contentPattern = statement.substring(preElsif.getNextIndex(), end.getIndex() - "#END".length() + 1);
            preElsif.setContentPattern(contentPattern);
            end.setPreNode(preElsif);
        } else if (node instanceof ELSE) {
            ELSE preElse = (ELSE)node;
            String contentPattern = statement.substring(preElse.getNextIndex(), end.getIndex() - "#END".length() + 1);
            preElse.setContentPattern(contentPattern);
            end.setPreNode(preElse);
            preElse.setEndNode(end);
        }
        this.outStack(statement, end);
    }

    private void outStack(String statement, END end) {
        IfEndBlock block = new IfEndBlock();
        block.setEndNode(end);
        Node a = null;
        do {
            if ((a = this.stack.pop()) instanceof IF) {
                block.setIfNode((IF)a);
            }
            if (a instanceof ELSIF) {
                block.addElsifNode((ELSIF)a);
            }
            if (!(a instanceof ELSE)) continue;
            block.setElseNode((ELSE)a);
        } while (!(a instanceof IF));
        if (this.stack.empty()) {
            this.ifEndBlockForResult = block;
        } else {
            Node node = this.stack.peek();
            if (node instanceof IF) {
                IF ifnode = (IF)node;
                ifnode.addIfEndBlock(block);
            } else if (node instanceof ELSIF) {
                ELSIF preElsif = (ELSIF)node;
                preElsif.addIfEndBlock(block);
            } else if (node instanceof ELSE) {
                ELSE preElse = (ELSE)node;
                preElse.addIfEndBlock(block);
            }
        }
    }

    private String parseFollowNodeContent(String statement, FollowNode fn) {
        if (fn instanceof END) {
            return "";
        }
        if (fn instanceof ELSIF) {
            ELSIF elsifTmp = (ELSIF)fn;
            if (this.handler.condition(elsifTmp.getCondition())) {
                List<IfEndBlock> list = elsifTmp.getIfEndBlockList();
                if (list.isEmpty()) {
                    return elsifTmp.getContentPattern();
                }
                int index = elsifTmp.getNextIndex();
                Tuple[] indexList = new Tuple[list.size()];
                String[] contentList = new String[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    IfEndBlock iebBlcok = list.get(i);
                    indexList[i] = Tuple.apply(iebBlcok.getIfNode().getIndex() + 1 - iebBlcok.getIfNode().getNodeName().length(), iebBlcok.getEndNode().getNextIndex());
                    contentList[i] = this.parseContent(statement, iebBlcok);
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < indexList.length; ++i) {
                    Tuple t;
                    if (i == 0) {
                        t = indexList[i];
                        int endIndex = (Integer)t.getObject(0);
                        sb.append(statement.substring(index, endIndex)).append(contentList[i]);
                    } else {
                        t = indexList[i];
                        Tuple t1 = indexList[i - 1];
                        int beginIndex = (Integer)t1.getObject(1);
                        int endIndex = (Integer)t.getObject(0);
                        sb.append(statement.substring(beginIndex, endIndex)).append(contentList[i]);
                    }
                    if (i != indexList.length - 1) continue;
                    t = indexList[indexList.length - 1];
                    int beginIndex = (Integer)t.getObject(1);
                    int endIndex = elsifTmp.getFollowNode().getIndex() + 1 - elsifTmp.getFollowNode().getNodeName().length();
                    sb.append(statement.substring(beginIndex, endIndex));
                }
                return sb.toString();
            }
            return this.parseFollowNodeContent(statement, ((ELSIF)fn).getFollowNode());
        }
        if (fn instanceof ELSE) {
            ELSE elseTmp = (ELSE)fn;
            List<IfEndBlock> list = elseTmp.getIfEndBlockList();
            if (list.isEmpty()) {
                return elseTmp.getContentPattern();
            }
            int index = elseTmp.getNextIndex();
            Tuple[] indexList = new Tuple[list.size()];
            String[] contentList = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                IfEndBlock iebBlcok = list.get(i);
                indexList[i] = Tuple.apply(iebBlcok.getIfNode().getIndex() + 1 - iebBlcok.getIfNode().getNodeName().length(), iebBlcok.getEndNode().getNextIndex());
                contentList[i] = this.parseContent(statement, iebBlcok);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indexList.length; ++i) {
                Tuple t;
                if (i == 0) {
                    t = indexList[i];
                    int endIndex = (Integer)t.getObject(0);
                    sb.append(statement.substring(index, endIndex)).append(contentList[i]);
                } else {
                    t = indexList[i];
                    Tuple t1 = indexList[i - 1];
                    int beginIndex = (Integer)t1.getObject(1);
                    int endIndex = (Integer)t.getObject(0);
                    sb.append(statement.substring(beginIndex, endIndex)).append(contentList[i]);
                }
                if (i != indexList.length - 1) continue;
                t = indexList[indexList.length - 1];
                int beginIndex = (Integer)t.getObject(1);
                int endIndex = elseTmp.getEndNode().getIndex() + 1 - elseTmp.getEndNode().getNodeName().length();
                sb.append(statement.substring(beginIndex, endIndex));
            }
            return sb.toString();
        }
        return "";
    }

    private String parseContent(String statement, IfEndBlock block) {
        if (block == null) {
            return "";
        }
        IF ifnode = block.getIfNode();
        List<IfEndBlock> list = ifnode.getIfEndBlockList();
        String condition = ifnode.getCondition();
        if (this.handler.condition(condition)) {
            if (list.isEmpty()) {
                return ifnode.getContentPattern();
            }
            int index = ifnode.getNextIndex();
            Tuple[] indexList = new Tuple[list.size()];
            String[] contentList = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                IfEndBlock iebBlcok = list.get(i);
                indexList[i] = Tuple.apply(iebBlcok.getIfNode().getIndex() + 1 - iebBlcok.getIfNode().getNodeName().length(), iebBlcok.getEndNode().getNextIndex());
                contentList[i] = this.parseContent(statement, iebBlcok);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < indexList.length; ++i) {
                Tuple t;
                if (i == 0) {
                    t = indexList[i];
                    int endIndex = (Integer)t.getObject(0);
                    sb.append(statement.substring(index, endIndex)).append(contentList[i]);
                } else {
                    t = indexList[i];
                    Tuple t1 = indexList[i - 1];
                    int beginIndex = (Integer)t1.getObject(1);
                    int endIndex = (Integer)t.getObject(0);
                    sb.append(statement.substring(beginIndex, endIndex)).append(contentList[i]);
                }
                if (i != indexList.length - 1) continue;
                t = indexList[indexList.length - 1];
                int beginIndex = (Integer)t.getObject(1);
                int endIndex = ifnode.getFollowNode().getIndex() + 1 - ifnode.getFollowNode().getNodeName().length();
                sb.append(statement.substring(beginIndex, endIndex));
            }
            return sb.toString();
        }
        FollowNode fn = ifnode.getFollowNode();
        return this.parseFollowNodeContent(statement, fn);
    }

    private void withElse(String statement, int index) {
        Node node = this.stack.peek();
        if (node == null) {
            throw new RuntimeException("else prenode not exist.");
        }
        ELSE elseNode = new ELSE();
        elseNode.setIndex(index);
        elseNode.setNextIndex(index + 1);
        if (node instanceof IF) {
            IF ifnode = (IF)node;
            ifnode.setFollowNode(elseNode);
            elseNode.setPreNode(ifnode);
            String contentPattern = statement.substring(ifnode.getNextIndex(), elseNode.getIndex() - "#ELSE".length() + 1);
            ifnode.setContentPattern(contentPattern);
        } else if (node instanceof ELSIF) {
            ELSIF preElsif = (ELSIF)node;
            preElsif.setFollowNode(elseNode);
            elseNode.setPreNode(preElsif);
            String contentPattern = statement.substring(preElsif.getNextIndex(), elseNode.getIndex() - "#ELSE".length() + 1);
            preElsif.setContentPattern(contentPattern);
        }
        this.stack.push(elseNode);
    }

    private void withElsif(String statement, int index) {
        Node node = this.stack.peek();
        if (node == null) {
            throw new RuntimeException("elsif prenode not exist.");
        }
        String left = statement.substring(index + 2);
        int tce = left.indexOf("]");
        String condition = left.substring(0, tce);
        ELSIF elsifNode = new ELSIF();
        elsifNode.setCondition(condition);
        elsifNode.setIndex(index);
        elsifNode.setNextIndex(index + 2 + tce + 1);
        if (node instanceof IF) {
            IF ifnode = (IF)node;
            ifnode.setFollowNode(elsifNode);
            elsifNode.setPreNode(ifnode);
            String contentPattern = statement.substring(ifnode.getNextIndex(), elsifNode.getIndex() - "#ELSIF".length() + 1);
            ifnode.setContentPattern(contentPattern);
        } else if (node instanceof ELSIF) {
            ELSIF preElsif = (ELSIF)node;
            preElsif.setFollowNode(elsifNode);
            elsifNode.setPreNode(preElsif);
            String contentPattern = statement.substring(preElsif.getNextIndex(), elsifNode.getIndex() - "#ELSIF".length() + 1);
            preElsif.setContentPattern(contentPattern);
        }
        this.stack.add(elsifNode);
    }

    private void withIf(String statement, int index) {
        String left = statement.substring(index + 2);
        int tce = left.indexOf("]");
        String condition = left.substring(0, tce);
        IF ifnode = new IF();
        ifnode.setCondition(condition);
        ifnode.setIndex(index);
        ifnode.setNextIndex(index + 2 + tce + 1);
        this.stack.add(ifnode);
    }
}

