/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.proxy.mapper;

import cn.sylinx.horm.proxy.annotation.PageNumber;
import cn.sylinx.horm.proxy.annotation.PageSize;
import cn.sylinx.horm.proxy.annotation.Param;
import cn.sylinx.horm.proxy.annotation.ParamBean;
import cn.sylinx.horm.util.BeanUtil;
import cn.sylinx.horm.util.Pair;
import cn.sylinx.horm.util.Tuple;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MapperMethodMetadata {
    private static final Map<String, MapperMethodMetadata> cachedMethod = new HashMap<String, MapperMethodMetadata>();
    private Class<?> mapperInterface;
    private Method method;
    private Annotation[][] parameterAnnotations;
    private Class<?> truelyReturnType;
    private Class<?> returnType;
    private String metaKey;

    private static String getMetaKey(Class<?> mapperInterface, Method method) {
        return mapperInterface.getName() + "." + method.getName();
    }

    public static MapperMethodMetadata get(Class<?> mapperInterface, Method method) {
        String key = MapperMethodMetadata.getMetaKey(mapperInterface, method);
        MapperMethodMetadata methodMetadata = MapperMethodMetadata.get(key);
        if (methodMetadata == null) {
            methodMetadata = MapperMethodMetadata.setAndGet(key, mapperInterface, method);
        }
        return methodMetadata;
    }

    private static MapperMethodMetadata get(String key) {
        return cachedMethod.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MapperMethodMetadata setAndGet(String key, Class<?> mapperInterface, Method method) {
        String string = key.intern();
        synchronized (string) {
            MapperMethodMetadata methodMetadata = MapperMethodMetadata.get(key);
            if (methodMetadata != null) {
                return methodMetadata;
            }
            methodMetadata = new MapperMethodMetadata(mapperInterface, method);
            cachedMethod.put(key, methodMetadata);
            return methodMetadata;
        }
    }

    public MapperMethodMetadata(Class<?> mapperInterface, Method method) {
        this.mapperInterface = mapperInterface;
        this.method = method;
        this.readMetadata();
    }

    private void readMetadata() {
        this.returnType = this.readReturnType();
        this.truelyReturnType = this.readTruelyReturnType();
        this.parameterAnnotations = this.readParameterAnnotations();
        this.metaKey = MapperMethodMetadata.getMetaKey(this.mapperInterface, this.method);
    }

    private Class<?> readReturnType() {
        return this.method.getReturnType();
    }

    private Annotation[][] readParameterAnnotations() {
        return this.method.getParameterAnnotations();
    }

    public Tuple resove(Object[] args) {
        Integer pageNumber = 0;
        Integer pageSize = 0;
        ArrayList<Pair> paramList = new ArrayList<Pair>();
        ArrayList<Map> mapList = new ArrayList<Map>();
        ArrayList<Object> beanList = new ArrayList<Object>();
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            Annotation[] ats = this.parameterAnnotations[i];
            if (ats != null && ats.length > 0) {
                if (ats[0].annotationType() == PageNumber.class) {
                    pageNumber = (Integer)args[i];
                }
                if (ats[0].annotationType() == PageSize.class) {
                    pageSize = (Integer)args[i];
                }
                if (ats[0].annotationType() == Param.class) {
                    paramList.add(Pair.apply((Object)ats[0], args[i]));
                }
                if (ats[0].annotationType() == ParamBean.class) {
                    beanList.add(args[i]);
                }
            }
            if (args[i] == null || !Map.class.isAssignableFrom(args[i].getClass())) continue;
            mapList.add((Map)args[i]);
        }
        HashMap ps = new HashMap();
        paramList.forEach(p -> {
            Param param = (Param)p.getObject(0);
            ps.put(param.value(), p.getObject(1));
        });
        mapList.forEach(map -> map.entrySet().forEach(entry -> ps.put(entry.getKey(), entry.getValue())));
        beanList.forEach(bean -> ps.putAll(BeanUtil.bean2map(bean)));
        if (pageNumber == null || pageNumber < 1) {
            pageNumber = Optional.ofNullable((Integer)ps.get("pageNumber")).orElse(0);
            pageSize = Optional.ofNullable((Integer)ps.get("pageSize")).orElse(0);
        }
        return Tuple.apply(ps, pageNumber, pageSize);
    }

    private Class<?> readTruelyReturnType() {
        Type genericReturnType = this.method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)genericReturnType).getActualTypeArguments();
            return (Class)actualTypeArguments[0];
        }
        return Object.class;
    }

    public Class<?> getTruelyReturnType() {
        return this.truelyReturnType;
    }

    public Class<?> getMapperInterface() {
        return this.mapperInterface;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public String getMetaKey() {
        return this.metaKey;
    }

    public void setMetaKey(String metaKey) {
        this.metaKey = metaKey;
    }
}

