/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.proxy.command.invoker;

import cn.sylinx.horm.core.common.Page;
import cn.sylinx.horm.core.common.Record;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.proxy.command.CommandMethodMetadata;
import cn.sylinx.horm.proxy.command.annotation.Resource;
import cn.sylinx.horm.proxy.command.annotation.ResourceType;
import cn.sylinx.horm.proxy.command.invoker.BeanListCommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.BeanPageCommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.BeanQueryOneCommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.CommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.ExecuteCommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.InsertCommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.ObjectListCommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.ObjectQueryOneCommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.RecordListCommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.RecordPageCommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.RecordQueryOneCommandInvoker;
import cn.sylinx.horm.proxy.command.invoker.UpdateCommandInvoker;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum CommandInvokerManager {

    private static Set<Class<?>> primaryOrMappedWrapTypeOrFrequentType = new HashSet(8);
    private static Map<String, CommandInvoker> commandInvokerMaps;
    private static Map<String, CommandInvoker> cachedCommandInvokerMaps;

    public static CommandInvoker getBy(CommandMethodMetadata methodMetadata) {
        String metaKey = methodMetadata.getMetaKey();
        if (cachedCommandInvokerMaps.containsKey(metaKey)) {
            return cachedCommandInvokerMaps.get(metaKey);
        }
        String cmdInvokerKey = CommandInvokerManager.parseMatchKey(methodMetadata);
        CommandInvoker commandDirectInvoker = commandInvokerMaps.get(cmdInvokerKey);
        if (commandDirectInvoker == null) {
            throw new HORMException("no suitable command invoker");
        }
        cachedCommandInvokerMaps.put(metaKey, commandDirectInvoker);
        return commandDirectInvoker;
    }

    private static String parseMatchKey(CommandMethodMetadata methodMetadata) {
        Resource resource = methodMetadata.getResource();
        Class<?> returnType = methodMetadata.getReturnType();
        Class<?> truelyReturnType = methodMetadata.getTruelyReturnType();
        if (CommandInvokerManager.isQuery(resource)) {
            StringBuilder sb = new StringBuilder();
            sb.append("QUERY.");
            if (returnType == List.class) {
                sb.append("LIST.");
                if (!CommandInvokerManager.isPrimaryOrMappedWrapTypeOrFrequentType(truelyReturnType) && !CommandInvokerManager.isRecordForTruelyReturnType(truelyReturnType)) {
                    sb.append("BEAN");
                    return sb.toString();
                }
                if (CommandInvokerManager.isRecordForTruelyReturnType(truelyReturnType)) {
                    sb.append("RECORD");
                    return sb.toString();
                }
                if (CommandInvokerManager.isPrimaryOrMappedWrapTypeOrFrequentType(truelyReturnType)) {
                    sb.append("OBJ");
                    return sb.toString();
                }
            }
            if (returnType == Page.class) {
                sb.append("PAGE.");
                if (CommandInvokerManager.isRecordForTruelyReturnType(truelyReturnType)) {
                    sb.append("RECORD");
                    return sb.toString();
                }
                if (!CommandInvokerManager.isRecordForTruelyReturnType(truelyReturnType)) {
                    sb.append("BEAN");
                    return sb.toString();
                }
            }
            if (returnType != List.class && returnType != Page.class) {
                sb.append("ONE.");
                if (!CommandInvokerManager.isPrimaryOrMappedWrapTypeOrFrequentType(returnType) && !CommandInvokerManager.isRecordForTruelyReturnType(returnType)) {
                    sb.append("BEAN");
                    return sb.toString();
                }
                if (CommandInvokerManager.isRecordForTruelyReturnType(returnType)) {
                    sb.append("RECORD");
                    return sb.toString();
                }
                if (CommandInvokerManager.isPrimaryOrMappedWrapTypeOrFrequentType(returnType)) {
                    sb.append("OBJ");
                    return sb.toString();
                }
            }
        }
        if (CommandInvokerManager.isUpdate(resource)) {
            return "UPDATE.";
        }
        if (CommandInvokerManager.isExecute(resource)) {
            return "EXECUTE.";
        }
        if (CommandInvokerManager.isInsert(resource)) {
            return "INSERT.";
        }
        return "NONE";
    }

    private static boolean isRecordForTruelyReturnType(Class<?> truelyReturnType) {
        return truelyReturnType == Record.class;
    }

    private static boolean isPrimaryOrMappedWrapTypeOrFrequentType(Class<?> truelyReturnType) {
        return primaryOrMappedWrapTypeOrFrequentType.contains(truelyReturnType);
    }

    private static boolean isQuery(Resource resource) {
        return ResourceType.QUERY == resource.resourceType();
    }

    private static boolean isInsert(Resource resource) {
        return ResourceType.INSERT == resource.resourceType();
    }

    private static boolean isUpdate(Resource resource) {
        return ResourceType.UPDATE == resource.resourceType();
    }

    private static boolean isExecute(Resource resource) {
        return ResourceType.EXECUTE == resource.resourceType();
    }

    static {
        primaryOrMappedWrapTypeOrFrequentType.add(Boolean.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Boolean.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Byte.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Byte.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Character.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Character.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Short.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Short.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Integer.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Integer.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Long.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Long.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Float.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Float.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(Double.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Double.TYPE);
        primaryOrMappedWrapTypeOrFrequentType.add(String.class);
        primaryOrMappedWrapTypeOrFrequentType.add(BigInteger.class);
        primaryOrMappedWrapTypeOrFrequentType.add(BigDecimal.class);
        primaryOrMappedWrapTypeOrFrequentType.add(Date.class);
        commandInvokerMaps = new HashMap<String, CommandInvoker>();
        cachedCommandInvokerMaps = new HashMap<String, CommandInvoker>();
        String updateKey = "UPDATE.";
        commandInvokerMaps.put(updateKey, new UpdateCommandInvoker());
        String insertKey = "INSERT.";
        commandInvokerMaps.put(insertKey, new InsertCommandInvoker());
        String executeKey = "EXECUTE.";
        commandInvokerMaps.put(executeKey, new ExecuteCommandInvoker());
        String queryKey1 = "QUERY.LIST.BEAN";
        commandInvokerMaps.put(queryKey1, new BeanListCommandInvoker());
        String queryKey2 = "QUERY.LIST.RECORD";
        commandInvokerMaps.put(queryKey2, new RecordListCommandInvoker());
        String queryKey3 = "QUERY.LIST.OBJ";
        commandInvokerMaps.put(queryKey3, new ObjectListCommandInvoker());
        String queryKey4 = "QUERY.PAGE.BEAN";
        commandInvokerMaps.put(queryKey4, new BeanPageCommandInvoker());
        String queryKey5 = "QUERY.PAGE.RECORD";
        commandInvokerMaps.put(queryKey5, new RecordPageCommandInvoker());
        String queryKey6 = "QUERY.ONE.BEAN";
        commandInvokerMaps.put(queryKey6, new BeanQueryOneCommandInvoker());
        String queryKey7 = "QUERY.ONE.RECORD";
        commandInvokerMaps.put(queryKey7, new RecordQueryOneCommandInvoker());
        String queryKey8 = "QUERY.ONE.OBJ";
        commandInvokerMaps.put(queryKey8, new ObjectQueryOneCommandInvoker());
    }
}

