/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.model.util;

import cn.sylinx.horm.model.anno.Column;
import cn.sylinx.horm.model.anno.Table;
import cn.sylinx.horm.util.StrKit;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelUtil {
    public static final void buildColumnNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }

    private static boolean isIgnoreField(Field f) {
        String modifiers = Modifier.toString(f.getModifiers());
        if (modifiers.contains("final") || modifiers.contains("static") || modifiers.contains("transient") || f.getName().equals("context")) {
            return true;
        }
        Column cd = f.getAnnotation(Column.class);
        return cd != null && cd.ignore();
    }

    public static List<Field> getObjectAllFields(Class<?> cclz) {
        List<Field> fds1;
        Class<?> pclz;
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] fs = cclz.getDeclaredFields();
        if (fs != null && fs.length > 0) {
            for (Field f : fs) {
                if (ModelUtil.isIgnoreField(f)) continue;
                fields.add(f);
            }
        }
        if ((pclz = cclz.getSuperclass()) != null && !pclz.isInterface() && (fds1 = ModelUtil.getObjectAllFields(pclz)) != null && !fds1.isEmpty()) {
            fields.addAll(fds1);
        }
        return fields;
    }

    public static Map<String, Field> getObjectAllFieldsMap(Class<?> cclz) {
        Map<String, Field> fds1;
        Class<?> pclz;
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field[] fs = cclz.getDeclaredFields();
        if (fs != null && fs.length > 0) {
            for (Field f : fs) {
                if (ModelUtil.isIgnoreField(f)) continue;
                fields.put(f.getName(), f);
                fields.put(f.getName().toUpperCase(), f);
            }
        }
        if ((pclz = cclz.getSuperclass()) != null && !pclz.isInterface() && (fds1 = ModelUtil.getObjectAllFieldsMap(pclz)) != null && !fds1.isEmpty()) {
            fields.putAll(fds1);
        }
        return fields;
    }

    public static String getModelTable(Class<?> clz) {
        Table table = clz.getAnnotation(Table.class);
        if (table != null) {
            return table.value();
        }
        return StrKit.enCodeUnderlined(clz.getSimpleName());
    }
}

