/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.type;

import cn.sylinx.horm.dialect.DbType;
import cn.sylinx.horm.dialect.type.TypeHandlerBuilder;
import cn.sylinx.horm.dialect.type.TypeHandlerBuilderSPI;
import cn.sylinx.horm.type.TypeHandlerRegistry;
import cn.sylinx.horm.util.ClassUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class TypeHandlerBuilderFactory {
    private static final TypeHandlerBuilderFactory instance = new TypeHandlerBuilderFactory();
    private final Map<DbType, TypeHandlerBuilder> registers = new HashMap<DbType, TypeHandlerBuilder>();
    private final TypeHandlerBuilder defaultTypeHandlerBuilder = TypeHandlerRegistry.getInstance();

    public static TypeHandlerBuilderFactory get() {
        return instance;
    }

    private TypeHandlerBuilderFactory() {
        this.registerDefault();
        this.loadFromService();
    }

    private void registerDefault() {
    }

    private final void loadFromService() {
        ServiceLoader<TypeHandlerBuilderSPI> thbSpi = ServiceLoader.load(TypeHandlerBuilderSPI.class, ClassUtil.getDefaultClassLoader());
        if (thbSpi != null) {
            Iterator<TypeHandlerBuilderSPI> thbIt = thbSpi.iterator();
            while (thbIt != null && thbIt.hasNext()) {
                Map<DbType, TypeHandlerBuilder> thbMaps = thbIt.next().create();
                if (thbMaps == null) continue;
                this.registers.putAll(thbMaps);
            }
        }
    }

    public TypeHandlerBuilder getTypeHandlerBuilder(DbType dbType) {
        TypeHandlerBuilder thb = this.registers.get(dbType);
        if (thb == null) {
            return this.defaultTypeHandlerBuilder;
        }
        return thb;
    }
}

