/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.spi;

import cn.sylinx.horm.dialect.Dialect;
import cn.sylinx.horm.util.ClassUtil;
import cn.sylinx.horm.util.GLog;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public enum DialectSPIManager {

    private static Map<String, Dialect> spiDialectMap = new HashMap<String, Dialect>();

    private static final void init() {
        ServiceLoader<Dialect> dialects = ServiceLoader.load(Dialect.class, ClassUtil.getDefaultClassLoader());
        if (dialects != null) {
            for (Dialect dialect : dialects) {
                String dbtype = dialect.getDbType().getValue();
                spiDialectMap.put(dbtype, dialect);
                GLog.info("register spi dbtype:{}", dbtype);
            }
        }
    }

    public static Dialect createDialectBySPI(String dbTypeName) {
        return spiDialectMap.get(dbTypeName);
    }

    static {
        DialectSPIManager.init();
    }
}

