/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.dialect.fs;

import cn.sylinx.horm.core.common.OrderBy;
import cn.sylinx.horm.dialect.fs.FluentSqlParams;
import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.model.anno.PrimaryKey;
import cn.sylinx.horm.model.cache.ModelCacheUtil;
import cn.sylinx.horm.model.cache.ModelFabric;
import cn.sylinx.horm.model.lambda.TypeFunction;
import cn.sylinx.horm.util.GLog;
import cn.sylinx.horm.util.LambdaUtil;
import cn.sylinx.horm.util.StrKit;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class FS<T> {
    public static final String AND_STR = " AND ";
    public static final String BLANK_STR = "";
    protected Class<T> modelClass;
    protected StringBuilder conditionSQL = new StringBuilder();
    protected StringBuilder orderBySQL = new StringBuilder();
    protected StringBuilder groupBySQL = new StringBuilder();
    protected StringBuilder limitSQL = new StringBuilder();
    protected List<String> excludedColumns = new ArrayList<String>(8);
    protected List<Object> paramValues = new ArrayList<Object>(8);
    protected Map<String, Object> updateColumns = new LinkedHashMap<String, Object>(8);
    protected Map<String, String> updateColumnExpression = new LinkedHashMap<String, String>(8);
    protected String selectColumns;
    protected String selectExpressionColumns;
    protected boolean distinct = false;
    protected boolean count = false;
    protected String[] primaryKeyColumn;
    protected String tableName;
    protected Map<String, String> attrs = null;
    protected T model;
    protected String preEscape;
    protected String postEscape;
    protected boolean singleField = false;
    protected String hint;
    protected String tablePostfix = "";
    protected String tablePrefix = "";

    public static <T> FS<T> of(Class<T> modelClass) {
        return FS.of(BLANK_STR, modelClass, BLANK_STR);
    }

    public static <T> FS<T> of(Class<T> modelClass, String tablePostfix) {
        return FS.of(BLANK_STR, modelClass, tablePostfix);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass) {
        return FS.of(tablePrefix, modelClass, BLANK_STR);
    }

    public static <T> FS<T> of(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return new FS<T>().init(tablePrefix, modelClass, tablePostfix);
    }

    protected String[] getEscape() {
        return new String[]{BLANK_STR, BLANK_STR};
    }

    public FS<T> init(Class<T> modelClass) {
        return this.init(BLANK_STR, modelClass, BLANK_STR);
    }

    public FS<T> init(String tablePrefix, Class<T> modelClass) {
        return this.init(tablePrefix, modelClass, BLANK_STR);
    }

    public FS<T> init(Class<T> modelClass, String tablePostfix) {
        return this.init(BLANK_STR, modelClass, tablePostfix);
    }

    public FS<T> init(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        return this.parse(tablePrefix, modelClass, tablePostfix);
    }

    public FluentSqlParams<T> build() {
        this.beforeCheck();
        FluentSqlParams<T> fsp = new FluentSqlParams<T>();
        fsp.setConditionSQL(this.conditionSQL);
        fsp.setModelClass(this.modelClass);
        fsp.setGroupBy(this.groupBySQL.toString());
        fsp.setOrderBy(this.orderBySQL.toString());
        fsp.setLimitSQL(this.limitSQL.toString());
        fsp.setExcludedColumns(this.excludedColumns);
        fsp.setParamValues(this.paramValues);
        fsp.setUpdateColumns(this.updateColumns);
        fsp.setUpdateColumnExpression(this.updateColumnExpression);
        fsp.setSelectColumns(this.selectColumns);
        fsp.setSelectExpressionColumns(this.selectExpressionColumns);
        fsp.setPrimaryKeyColumn(this.primaryKeyColumn);
        fsp.setTableName(this.tableName);
        fsp.setModel(this.model);
        fsp.setDistinct(this.distinct);
        fsp.setCount(this.count);
        fsp.setAttrs(this.attrs);
        fsp.setPreEscape(this.preEscape);
        fsp.setPostEscape(this.postEscape);
        fsp.setSingleField(this.singleField);
        fsp.setHint(this.hint);
        fsp.setTablePrefix(this.tablePrefix);
        fsp.setTablePostfix(this.tablePostfix);
        return fsp;
    }

    protected String getDefaultTableName() {
        return this.preEscape + this.tablePrefix + ModelCacheUtil.getModelFabric(this.modelClass).getTableName() + this.tablePostfix + this.postEscape;
    }

    private FS<T> parse(String tablePrefix, Class<T> modelClass, String tablePostfix) {
        String[] stringArray;
        this.tablePrefix = tablePrefix == null ? BLANK_STR : tablePrefix.trim();
        this.tablePostfix = tablePostfix == null ? BLANK_STR : tablePostfix.trim();
        String[] escapes = this.getEscape();
        this.preEscape = escapes[0];
        this.postEscape = escapes[1];
        this.modelClass = modelClass;
        this.tableName = this.getDefaultTableName();
        PrimaryKey pk = ModelCacheUtil.getModelFabric(modelClass).getPrimaryKey();
        if (pk == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "id";
        } else {
            stringArray = pk.value();
        }
        this.primaryKeyColumn = stringArray;
        ModelFabric mf = ModelCacheUtil.getModelFabric(modelClass);
        this.attrs = mf.getAttrMapping();
        if (this.attrs == null) {
            this.attrs = new HashMap<String, String>();
        }
        return this;
    }

    public FS<T> exclude(String ... columnNames) {
        if (columnNames == null) {
            throw new HORMException("exclude columnNames is null");
        }
        ArrayList<String> columnExcludeList = new ArrayList<String>();
        for (int i = 0; i < columnNames.length; ++i) {
            columnExcludeList.add(columnNames[i]);
            columnExcludeList.add(this.mapColumn(columnNames[i]));
        }
        String[] tempColumnNames = new String[columnExcludeList.size()];
        columnExcludeList.toArray(tempColumnNames);
        Collections.addAll(this.excludedColumns, tempColumnNames);
        return this;
    }

    @SafeVarargs
    public final <R> FS<T> exclude(TypeFunction<T, R> ... lambdaArray) {
        String[] columnNames = new String[lambdaArray.length];
        for (int i = 0; i < lambdaArray.length; ++i) {
            columnNames[i] = LambdaUtil.getLambdaFieldName(lambdaArray[i]);
        }
        return this.exclude(columnNames);
    }

    public FS<T> select(String columns) {
        if (null != this.selectColumns) {
            throw new HORMException("Select method can only be called once.");
        }
        this.selectColumns = this.mapColumns(columns);
        return this;
    }

    public FS<T> selectExp(String exp) {
        if (null != this.selectExpressionColumns) {
            throw new HORMException("SelectExp method can only be called once.");
        }
        this.selectExpressionColumns = exp;
        return this;
    }

    public FS<T> select(String ... columnArray) {
        if (null != this.selectColumns) {
            throw new HORMException("Select method can only be called once.");
        }
        this.selectColumns = this.mapColumns(columnArray);
        return this;
    }

    @SafeVarargs
    public final <R> FS<T> select(TypeFunction<T, R> ... lambdaArray) {
        String[] columnNames = new String[lambdaArray.length];
        for (int i = 0; i < lambdaArray.length; ++i) {
            columnNames[i] = LambdaUtil.getLambdaFieldName(lambdaArray[i]);
        }
        return this.select(columnNames);
    }

    public FS<T> hint(String hint) {
        this.hint = hint;
        return this;
    }

    public FS<T> distinct() {
        this.distinct = true;
        return this;
    }

    public FS<T> count() {
        this.count = true;
        return this;
    }

    public FS<T> singleField(String column) {
        this.select(column);
        this.singleField = true;
        return this;
    }

    public <R> FS<T> singleField(TypeFunction<T, R> lambda) {
        return this.singleField(LambdaUtil.getLambdaFieldName(lambda));
    }

    private String mapColumns(String[] columnArray) {
        this.beforeCheck();
        if (columnArray == null || columnArray.length == 0) {
            return null;
        }
        StringBuilder mappedClumns = new StringBuilder();
        for (String column : columnArray) {
            mappedClumns.append(this.mapColumn(column.trim())).append(",");
        }
        mappedClumns.deleteCharAt(mappedClumns.length() - 1);
        return mappedClumns.toString();
    }

    private String mapColumns(String columns) {
        String[] columnArray;
        this.beforeCheck();
        if (StrKit.isBlank(columns)) {
            return null;
        }
        StringBuilder mappedClumns = new StringBuilder();
        for (String column : columnArray = columns.split(",")) {
            mappedClumns.append(this.mapColumn(column.trim())).append(",");
        }
        mappedClumns.deleteCharAt(mappedClumns.length() - 1);
        return mappedClumns.toString();
    }

    private String mapColumn(String column) {
        String trueColumn = this.attrs.get(column);
        return this.preEscape + (trueColumn == null ? column : trueColumn) + this.postEscape;
    }

    public FS<T> where(String column) {
        String trueStatement = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueStatement);
        return this;
    }

    public FS<T> where() {
        this.conditionSQL.append(AND_STR);
        return this;
    }

    public FS<T> whereExp(String exp) {
        this.conditionSQL.append(AND_STR).append(exp);
        return this;
    }

    public <R> FS<T> where(TypeFunction<T, R> lambda) {
        return this.where((T)LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> where(String column, Object value) {
        String trueStatement = this.mapColumn(column) + " = ?";
        this.conditionSQL.append(AND_STR).append(trueStatement);
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> where(TypeFunction<T, R> lambda, Object value) {
        return this.where(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> where(T model) {
        ModelFabric mf = ModelCacheUtil.getModelFabric(model.getClass());
        List<Field> declaredFields = mf.getFields();
        Map<String, String> attrs = mf.getAttrMapping();
        try {
            for (Field declaredField : declaredFields) {
                Object value = declaredField.get(model);
                if (null == value || declaredField.getType().equals(String.class) && StrKit.isBlank(value.toString())) continue;
                String columnName = attrs.get(declaredField.getName());
                this.where(columnName, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            GLog.error("where model error:", e);
        }
        return this;
    }

    public FS<T> eq(Object value) {
        this.conditionSQL.append(" = ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> notNull() {
        this.conditionSQL.append(" IS NOT NULL");
        return this;
    }

    public FS<T> and(String column, Object value) {
        return this.where(column, value);
    }

    public <R> FS<T> and(TypeFunction<T, R> lambda, Object value) {
        return this.and(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> and(String column) {
        return this.where((T)column);
    }

    public <R> FS<T> and(TypeFunction<T, R> lambda) {
        return this.and(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> or(String column, Object value) {
        String trueStatement = this.mapColumn(column) + " = ?";
        this.conditionSQL.append(" OR (").append(trueStatement);
        this.conditionSQL.append(')');
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> or(TypeFunction<T, R> lambda, Object value) {
        return this.or(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> andNotEq(String columnName, Object value) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" != ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> andNotEq(TypeFunction<T, R> lambda, Object value) {
        return this.andNotEq(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> notEq(Object value) {
        this.conditionSQL.append(" != ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> andNotEmpty(String columnName) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" != ''");
        return this;
    }

    public FS<T> notEmpty(String columnName) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" != ''");
        return this;
    }

    public FS<T> notEmpty() {
        this.conditionSQL.append(" != ''");
        return this;
    }

    public FS<T> andNotNull(String columnName) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" IS NOT NULL");
        return this;
    }

    public <R> FS<T> andNotNull(TypeFunction<T, R> lambda) {
        return this.andNotNull(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> notNull(String columnName) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" IS NOT NULL");
        return this;
    }

    public FS<T> isNull() {
        this.conditionSQL.append(" IS NULL");
        return this;
    }

    public FS<T> isNull(String columnName) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" IS NULL");
        return this;
    }

    public FS<T> andIsNull(String columnName) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" IS NULL");
        return this;
    }

    public <R> FS<T> andIsNull(TypeFunction<T, R> lambda) {
        return this.andIsNull(LambdaUtil.getLambdaFieldName(lambda));
    }

    public <R> FS<T> isNull(TypeFunction<T, R> lambda) {
        return this.isNull(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> limit(int size) {
        return this.limit(0, size);
    }

    public FS<T> limit(int offset, int size) {
        if (this.limitSQL.length() == 0) {
            this.limitSQL.append(" LIMIT ").append(offset).append(", ").append(size);
        }
        return this;
    }

    public <R> FS<T> notNull(TypeFunction<T, R> lambda) {
        return this.notNull(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> andLike(String columnName, Object value) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" LIKE ?");
        this.paramValues.add("%" + value + "%");
        return this;
    }

    public <R> FS<T> andLike(TypeFunction<T, R> lambda, Object value) {
        return this.andLike(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> like(Object value) {
        this.conditionSQL.append(" LIKE ?");
        this.paramValues.add("%" + value + "%");
        return this;
    }

    public FS<T> like(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(trueColumnName).append(" LIKE ?");
        this.paramValues.add("%" + value + "%");
        return this;
    }

    public <R> FS<T> like(TypeFunction<T, R> lambda, Object value) {
        return this.like(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> andLikeLeft(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" LIKE ?");
        this.paramValues.add("%" + value);
        return this;
    }

    public <R> FS<T> andLikeLeft(TypeFunction<T, R> lambda, Object value) {
        return this.andLikeLeft(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> likeLeft(Object value) {
        this.conditionSQL.append(" LIKE ?");
        this.paramValues.add("%" + value);
        return this;
    }

    public FS<T> likeLeft(String columnName, Object value) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" LIKE ?");
        this.paramValues.add("%" + value);
        return this;
    }

    public <R> FS<T> likeLeft(TypeFunction<T, R> lambda, Object value) {
        return this.likeLeft(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> andLikeRight(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" LIKE ?");
        this.paramValues.add(value + "%");
        return this;
    }

    public <R> FS<T> andLikeRight(TypeFunction<T, R> lambda, Object value) {
        return this.andLikeRight(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> likeRight(Object value) {
        this.conditionSQL.append(" LIKE ?");
        this.paramValues.add(value + "%");
        return this;
    }

    public FS<T> likeRight(String columnName, Object value) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" LIKE ?");
        this.paramValues.add(value + "%");
        return this;
    }

    public <R> FS<T> likeRight(TypeFunction<T, R> lambda, Object value) {
        return this.likeRight(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> andBetween(String columnName, Object a, Object b) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public FS<T> andNotBetween(String columnName, Object a, Object b) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(columnName)).append(" NOT BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public <R> FS<T> andBetween(TypeFunction<T, R> lambda, Object a, Object b) {
        return this.andBetween(LambdaUtil.getLambdaFieldName(lambda), a, b);
    }

    public <R> FS<T> andNotBetween(TypeFunction<T, R> lambda, Object a, Object b) {
        return this.andNotBetween(LambdaUtil.getLambdaFieldName(lambda), a, b);
    }

    public FS<T> between(Object a, Object b) {
        this.conditionSQL.append(" BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public FS<T> notBetween(Object a, Object b) {
        this.conditionSQL.append(" NOT BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public FS<T> between(String columnName, Object a, Object b) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public FS<T> notBetween(String columnName, Object a, Object b) {
        this.conditionSQL.append(this.mapColumn(columnName)).append(" NOT BETWEEN ? and ?");
        this.paramValues.add(a);
        this.paramValues.add(b);
        return this;
    }

    public <R> FS<T> between(TypeFunction<T, R> lambda, Object a, Object b) {
        return this.between(LambdaUtil.getLambdaFieldName(lambda), a, b);
    }

    public <R> FS<T> notBetween(TypeFunction<T, R> lambda, Object a, Object b) {
        return this.notBetween(LambdaUtil.getLambdaFieldName(lambda), a, b);
    }

    public FS<T> andGt(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" > ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> andGt(TypeFunction<T, R> lambda, Object value) {
        return this.andGt(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> gt(Object value) {
        this.conditionSQL.append(" > ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> gt(String columnName, Object value) {
        String trueColumnName = this.mapColumn(columnName);
        this.conditionSQL.append(trueColumnName).append(" > ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> gt(TypeFunction<T, R> lambda, Object value) {
        return this.gt(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> andGte(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" >= ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> andGte(TypeFunction<T, R> lambda, Object value) {
        return this.andGte(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> gte(Object value) {
        this.conditionSQL.append(" >= ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> andLt(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" < ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> andLt(TypeFunction<T, R> lambda, Object value) {
        return this.andLt(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> lt(Object value) {
        this.conditionSQL.append(" < ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> andLte(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" <= ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> andLte(TypeFunction<T, R> lambda, Object value) {
        return this.andLte(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> lte(Object value) {
        this.conditionSQL.append(" <= ?");
        this.paramValues.add(value);
        return this;
    }

    public FS<T> gte(String column, Object value) {
        this.conditionSQL.append(this.mapColumn(column)).append(" >= ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> gte(TypeFunction<T, R> lambda, Object value) {
        return this.gte(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> lt(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(trueColumnName).append(" < ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> lt(TypeFunction<T, R> lambda, Object value) {
        return this.lt(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> lte(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(trueColumnName).append(" <= ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> lte(TypeFunction<T, R> lambda, Object value) {
        return this.lte(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> andIn(String column, Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("column:{}, in params is empty.", column);
            return this;
        }
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public FS<T> andNotIn(String column, Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("column:{}, in params is empty.", column);
            return this;
        }
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(AND_STR).append(trueColumnName).append(" NOT IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public FS<T> in(String column, Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("column:{}, in params is empty.", column);
            return this;
        }
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(trueColumnName).append(" IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public FS<T> notIn(String column, Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("column:{}, in params is empty.", column);
            return this;
        }
        String trueColumnName = this.mapColumn(column);
        this.conditionSQL.append(trueColumnName).append(" NOT IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public <R> FS<T> in(TypeFunction<T, R> lambda, Object ... args) {
        return this.in(LambdaUtil.getLambdaFieldName(lambda), args);
    }

    public <R> FS<T> notIn(TypeFunction<T, R> lambda, Object ... args) {
        return this.notIn(LambdaUtil.getLambdaFieldName(lambda), args);
    }

    public <R> FS<T> andIn(TypeFunction<T, R> lambda, Object ... args) {
        return this.andIn(LambdaUtil.getLambdaFieldName(lambda), args);
    }

    public <R> FS<T> andNotIn(TypeFunction<T, R> lambda, Object ... args) {
        return this.andNotIn(LambdaUtil.getLambdaFieldName(lambda), args);
    }

    public FS<T> in(Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("Column: {}, query params is empty.", new Object[0]);
            return this;
        }
        this.conditionSQL.append(" IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public FS<T> notIn(Object ... args) {
        if (null == args || args.length == 0) {
            GLog.error("Column: {}, query params is empty.", new Object[0]);
            return this;
        }
        this.conditionSQL.append(" NOT IN (");
        this.setArguments(args);
        this.conditionSQL.append(")");
        return this;
    }

    public <S> FS<T> in(List<S> list) {
        return this.in(list.toArray());
    }

    public <S> FS<T> notIn(List<S> list) {
        return this.notIn(list.toArray());
    }

    public <S> FS<T> in(String column, List<S> args) {
        return this.in(column, args.toArray());
    }

    public <S> FS<T> notIn(String column, List<S> args) {
        return this.notIn(column, args.toArray());
    }

    public <R, S> FS<T> in(TypeFunction<T, R> lambda, List<S> args) {
        return this.in(LambdaUtil.getLambdaFieldName(lambda), args);
    }

    public <R, S> FS<T> notIn(TypeFunction<T, R> lambda, List<S> args) {
        return this.notIn(LambdaUtil.getLambdaFieldName(lambda), args);
    }

    public <S> FS<T> andIn(String column, List<S> args) {
        return this.andIn(column, args.toArray());
    }

    public <S> FS<T> andNotIn(String column, List<S> args) {
        return this.andNotIn(column, args.toArray());
    }

    public <R, S> FS<T> andIn(TypeFunction<T, R> lambda, List<S> args) {
        return this.andIn(LambdaUtil.getLambdaFieldName(lambda), args);
    }

    public <R, S> FS<T> andNotIn(TypeFunction<T, R> lambda, List<S> args) {
        return this.andNotIn(LambdaUtil.getLambdaFieldName(lambda), args);
    }

    public FS<T> order(String order) {
        String orderTemp;
        if (StrKit.isBlank(order)) {
            throw new HORMException("order is empty");
        }
        if (this.orderBySQL.length() > 0) {
            this.orderBySQL.append(',');
        }
        String newOrder = orderTemp = order.trim();
        String column = null;
        String flag = null;
        int index = orderTemp.indexOf(" ");
        if (index > -1) {
            column = orderTemp.substring(0, index);
            flag = orderTemp.substring(index);
            newOrder = this.mapColumn(column) + " " + flag;
        }
        this.orderBySQL.append(' ').append(newOrder);
        return this;
    }

    public FS<T> order(String columnName, OrderBy orderBy) {
        if (this.orderBySQL.length() > 0) {
            this.orderBySQL.append(',');
        }
        String trueColumnName = this.mapColumn(columnName);
        this.orderBySQL.append(' ').append(trueColumnName).append(' ').append(orderBy.toString());
        return this;
    }

    public FS<T> groupByExp(String exps) {
        if (this.groupBySQL.length() > 0) {
            throw new HORMException("group by sql can only be set once.");
        }
        if (exps == null) {
            throw new HORMException("groupBy \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.groupBySQL.append(' ').append(exps);
        return this;
    }

    public FS<T> groupBy(String ... columnNames) {
        if (this.groupBySQL.length() > 0) {
            throw new HORMException("group by sql can only be set once.");
        }
        if (columnNames == null || columnNames.length == 0) {
            throw new HORMException("groupBy \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (String columnName : columnNames) {
            String trueColumnName = this.mapColumn(columnName);
            this.groupBySQL.append(' ').append(trueColumnName).append(",");
        }
        this.groupBySQL.deleteCharAt(this.groupBySQL.length() - 1);
        return this;
    }

    @SafeVarargs
    public final <R> FS<T> groupBy(TypeFunction<T, R> ... lambdaArray) {
        String[] columnNames = new String[lambdaArray.length];
        for (int i = 0; i < lambdaArray.length; ++i) {
            columnNames[i] = LambdaUtil.getLambdaFieldName(lambdaArray[i]);
        }
        return this.groupBy(columnNames);
    }

    public <R> FS<T> order(TypeFunction<T, R> lambda, OrderBy orderBy) {
        return this.order(LambdaUtil.getLambdaFieldName(lambda), orderBy);
    }

    public FS<T> set(String column, Object value) {
        String trueColumnName = this.mapColumn(column);
        this.updateColumns.put(trueColumnName, value);
        return this;
    }

    public FS<T> inc(String column, Number count) {
        String trueColumnName = this.mapColumn(column);
        String exp = trueColumnName + " + " + count;
        this.setExp(trueColumnName, exp);
        return this;
    }

    public <R> FS<T> inc(TypeFunction<T, R> lambda, Number count) {
        return this.inc(LambdaUtil.getLambdaFieldName(lambda), count);
    }

    public FS<T> dec(String column, Number count) {
        String trueColumnName = this.mapColumn(column);
        String exp = trueColumnName + " - " + count;
        this.setExp(trueColumnName, exp);
        return this;
    }

    public <R> FS<T> dec(TypeFunction<T, R> lambda, Number count) {
        return this.dec(LambdaUtil.getLambdaFieldName(lambda), count);
    }

    public FS<T> inc(String column) {
        return this.inc(column, (Number)1);
    }

    public <R> FS<T> inc(TypeFunction<T, R> lambda) {
        return this.inc(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> dec(String column) {
        return this.dec(column, (Number)1);
    }

    public <R> FS<T> dec(TypeFunction<T, R> lambda) {
        return this.dec(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> setExp(String column, String exp) {
        String trueColumnName = this.mapColumn(column);
        this.updateColumnExpression.put(trueColumnName, exp);
        return this;
    }

    public <R> FS<T> set(TypeFunction<T, R> lambda, Object value) {
        return this.set(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public <R> FS<T> setExp(TypeFunction<T, R> lambda, String exp) {
        return this.setExp(LambdaUtil.getLambdaFieldName(lambda), exp);
    }

    public FS<T> set(T model) {
        this.model = model;
        return this;
    }

    private void setArguments(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (i == args.length - 1) {
                this.conditionSQL.append("?");
            } else {
                this.conditionSQL.append("?, ");
            }
            this.paramValues.add(args[i]);
        }
    }

    private void beforeCheck() {
        if (null == this.modelClass) {
            throw new HORMException("model calss is null");
        }
    }

    public FS<T> orNest(Function<FS<T>, FS<T>> func) {
        return this.or().nest(func);
    }

    public FS<T> andNest(Function<FS<T>, FS<T>> func) {
        return this.and().nest(func);
    }

    public FS<T> nest(Function<FS<T>, FS<T>> func) {
        this.conditionSQL.append("(");
        func.apply(this);
        this.conditionSQL.append(")");
        return this;
    }

    public FS<T> and() {
        this.conditionSQL.append(AND_STR);
        return this;
    }

    public FS<T> or() {
        this.conditionSQL.append(" OR ");
        return this;
    }

    public FS<T> eq(String column, Object value) {
        this.conditionSQL.append(this.mapColumn(column)).append(" = ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> eq(TypeFunction<T, R> lambda, Object value) {
        return this.eq(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> andEq(String column, Object value) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column)).append(" = ?");
        this.paramValues.add(value);
        return this;
    }

    public <R> FS<T> andEq(TypeFunction<T, R> lambda, Object value) {
        return this.andEq(LambdaUtil.getLambdaFieldName(lambda), value);
    }

    public FS<T> ltMeta(String column) {
        this.conditionSQL.append(" < ").append(this.mapColumn(column));
        return this;
    }

    public <R> FS<T> ltMeta(TypeFunction<T, R> lambda) {
        return this.ltMeta(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> exp(String exp) {
        this.conditionSQL.append(exp);
        return this;
    }

    public FS<T> andExp(String exp) {
        this.conditionSQL.append(AND_STR).append(exp);
        return this;
    }

    public FS<T> ltExp(String exp) {
        this.conditionSQL.append(" < ").append(exp);
        return this;
    }

    public FS<T> lteMeta(String column) {
        this.conditionSQL.append(" <= ").append(this.mapColumn(column));
        return this;
    }

    public <R> FS<T> lteMeta(TypeFunction<T, R> lambda) {
        return this.lteMeta(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> lteExp(String exp) {
        this.conditionSQL.append(" <= ").append(exp);
        return this;
    }

    public FS<T> ltMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" < ").append(this.mapColumn(column2));
        return this;
    }

    public FS<T> andLtMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" < ").append(this.mapColumn(column2));
        return this;
    }

    public <R> FS<T> ltMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.ltMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public <R> FS<T> andLtMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.andLtMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public FS<T> lteMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" <= ").append(this.mapColumn(column2));
        return this;
    }

    public FS<T> andLteMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" <= ").append(this.mapColumn(column2));
        return this;
    }

    public <R> FS<T> lteMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.lteMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public <R> FS<T> andLteMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.andLteMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public FS<T> eqMeta(String column) {
        this.conditionSQL.append(" = ").append(this.mapColumn(column));
        return this;
    }

    public FS<T> eqExp(String exp) {
        this.conditionSQL.append(" = ").append(exp);
        return this;
    }

    public <R> FS<T> eqMeta(TypeFunction<T, R> lambda) {
        return this.eqMeta(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> eqMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" = ").append(this.mapColumn(column2));
        return this;
    }

    public FS<T> andEqMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" = ").append(this.mapColumn(column2));
        return this;
    }

    public <R> FS<T> eqMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.eqMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public <R> FS<T> andEqMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.andEqMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public FS<T> gtMeta(String column) {
        this.conditionSQL.append(" > ").append(this.mapColumn(column));
        return this;
    }

    public FS<T> gtExp(String exp) {
        this.conditionSQL.append(" > ").append(exp);
        return this;
    }

    public <R> FS<T> gtMeta(TypeFunction<T, R> lambda) {
        return this.gtMeta(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> gtMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" > ").append(this.mapColumn(column2));
        return this;
    }

    public FS<T> andGtMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" > ").append(this.mapColumn(column2));
        return this;
    }

    public <R> FS<T> gtMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.gtMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public <R> FS<T> andGtMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.andGtMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public FS<T> gteMeta(String column) {
        this.conditionSQL.append(" >= ").append(this.mapColumn(column));
        return this;
    }

    public FS<T> gteExp(String exp) {
        this.conditionSQL.append(" >= ").append(exp);
        return this;
    }

    public <R> FS<T> gteMeta(TypeFunction<T, R> lambda) {
        return this.gteMeta(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> gteMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" >= ").append(this.mapColumn(column2));
        return this;
    }

    public FS<T> andGteMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" >= ").append(this.mapColumn(column2));
        return this;
    }

    public <R> FS<T> gteMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.gteMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public <R> FS<T> andGteMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.andGteMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public FS<T> notEqMeta(String column) {
        this.conditionSQL.append(" != ").append(this.mapColumn(column));
        return this;
    }

    public FS<T> notEqExp(String exp) {
        this.conditionSQL.append(" != ").append(exp);
        return this;
    }

    public <R> FS<T> notEqMeta(TypeFunction<T, R> lambda) {
        return this.notEqMeta(LambdaUtil.getLambdaFieldName(lambda));
    }

    public FS<T> notEqMeta(String column1, String column2) {
        this.conditionSQL.append(this.mapColumn(column1)).append(" != ").append(this.mapColumn(column2));
        return this;
    }

    public FS<T> andNotEqMeta(String column1, String column2) {
        this.conditionSQL.append(AND_STR).append(this.mapColumn(column1)).append(" != ").append(this.mapColumn(column2));
        return this;
    }

    public <R> FS<T> notEqMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.notEqMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public <R> FS<T> andNotEqMeta(TypeFunction<T, R> lambda1, TypeFunction<T, R> lambda2) {
        return this.andNotEqMeta(LambdaUtil.getLambdaFieldName(lambda1), LambdaUtil.getLambdaFieldName(lambda2));
    }

    public FS<T> setNull(String column) {
        return this.set(column, null);
    }

    public <R> FS<T> setNull(TypeFunction<T, R> lambda) {
        return this.setNull(LambdaUtil.getLambdaFieldName(lambda));
    }
}

