/*
 * Decompiled with CFR 0.152.
 */
package cn.sylinx.horm.core.common;

import cn.sylinx.horm.exception.HORMException;
import cn.sylinx.horm.util.StrKit;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public class Record
implements Serializable {
    private static final long serialVersionUID = 8681646517823266152L;
    private HashMap<String, Object> result = new HashMap();
    private HashMap<Integer, String> indexMap = new HashMap();

    public void put(String column, Object value) {
        this.put(column, null, value);
    }

    public void put(String column, Integer index, Object value) {
        String columnAlias = column.toUpperCase();
        if (index != null) {
            this.indexMap.put(index, columnAlias);
        }
        this.result.put(columnAlias, value);
    }

    public Object get(String column) {
        return this.result.get(column.toUpperCase());
    }

    public Object get(int index) {
        if (index < 1) {
            throw new HORMException("\u7d22\u5f15\u8d77\u59cb\u4f4d\u4e3a1");
        }
        String column = this.indexMap.get(index);
        if (StrKit.isNotBlank(column)) {
            return this.get(column);
        }
        throw new HORMException("\u7d22\u5f15\u6ca1\u6709\u627e\u5230");
    }

    public String getString(String column) {
        Object r = this.get(column);
        if (r instanceof String) {
            return (String)r;
        }
        if (r != null) {
            return r.toString();
        }
        return null;
    }

    public String getString(int index) {
        Object r = this.get(index);
        if (r instanceof String) {
            return (String)r;
        }
        if (r != null) {
            return r.toString();
        }
        return null;
    }

    public Integer getInteger(String column) {
        Object r = this.get(column);
        if (r instanceof Integer) {
            return (Integer)r;
        }
        if (r != null) {
            return Integer.valueOf(r.toString());
        }
        return null;
    }

    public Integer getInteger(int index) {
        Object r = this.get(index);
        if (r instanceof Integer) {
            return (Integer)r;
        }
        if (r != null) {
            return Integer.valueOf(r.toString());
        }
        return null;
    }

    public Long getLong(String column) {
        Object r = this.get(column);
        if (r instanceof Long) {
            return (Long)r;
        }
        if (r != null) {
            return Long.parseLong(r.toString());
        }
        return null;
    }

    public Long getLong(int index) {
        Object r = this.get(index);
        if (r instanceof Long) {
            return (Long)r;
        }
        if (r != null) {
            return Long.parseLong(r.toString());
        }
        return null;
    }

    public BigInteger getBigInteger(String column) {
        Object r = this.get(column);
        if (r instanceof BigInteger) {
            return (BigInteger)r;
        }
        if (r != null) {
            return new BigInteger(r.toString());
        }
        return null;
    }

    public BigInteger getBigInteger(int index) {
        Object r = this.get(index);
        if (r instanceof BigInteger) {
            return (BigInteger)r;
        }
        if (r != null) {
            return new BigInteger(r.toString());
        }
        return null;
    }

    public Date getDate(String column) {
        return (Date)this.get(column);
    }

    public Date getDate(int index) {
        return (Date)this.get(index);
    }

    public Time getTime(String column) {
        return (Time)this.get(column);
    }

    public Time getTime(int index) {
        return (Time)this.get(index);
    }

    public Timestamp getTimestamp(String column) {
        return (Timestamp)this.get(column);
    }

    public Timestamp getTimestamp(int index) {
        return (Timestamp)this.get(index);
    }

    public Double getDouble(String column) {
        Object r = this.get(column);
        if (r instanceof Double) {
            return (Double)r;
        }
        if (r != null) {
            return Double.valueOf(r.toString());
        }
        return null;
    }

    public Double getDouble(int index) {
        Object r = this.get(index);
        if (r instanceof Double) {
            return (Double)r;
        }
        if (r != null) {
            return Double.valueOf(r.toString());
        }
        return null;
    }

    public Float getFloat(String column) {
        Object r = this.get(column);
        if (r instanceof Float) {
            return (Float)r;
        }
        if (r != null) {
            return Float.valueOf(r.toString());
        }
        return null;
    }

    public Float getFloat(int index) {
        Object r = this.get(index);
        if (r instanceof Float) {
            return (Float)r;
        }
        if (r != null) {
            return Float.valueOf(r.toString());
        }
        return null;
    }

    public Boolean getBoolean(String column) {
        Object r = this.get(column);
        if (r instanceof Boolean) {
            return (Boolean)r;
        }
        if (r != null) {
            return Boolean.valueOf(r.toString());
        }
        return null;
    }

    public Boolean getBoolean(int index) {
        Object r = this.get(index);
        if (r instanceof Boolean) {
            return (Boolean)r;
        }
        if (r != null) {
            return Boolean.valueOf(r.toString());
        }
        return null;
    }

    public Byte getByte(String column) {
        Object r = this.get(column);
        if (r instanceof Byte) {
            return (Byte)r;
        }
        if (r != null) {
            return Byte.valueOf(r.toString());
        }
        return null;
    }

    public Byte getByte(int index) {
        Object r = this.get(index);
        if (r instanceof Byte) {
            return (Byte)r;
        }
        if (r != null) {
            return Byte.valueOf(r.toString());
        }
        return null;
    }

    public <T> T get(String column, Class<T> clz) {
        Object r = this.get(column);
        if (clz.isAssignableFrom(r.getClass())) {
            return (T)r;
        }
        return null;
    }

    public <T> T get(int index, Class<T> clz) {
        Object r = this.get(index);
        if (clz.isAssignableFrom(r.getClass())) {
            return (T)r;
        }
        return null;
    }

    public BigDecimal getBigDecimal(String column) {
        Object r = this.get(column);
        if (r instanceof BigDecimal) {
            return (BigDecimal)r;
        }
        if (r != null) {
            return new BigDecimal(r.toString());
        }
        return null;
    }

    public BigDecimal getBigDecimal(int index) {
        Object r = this.get(index);
        if (r instanceof BigDecimal) {
            return (BigDecimal)r;
        }
        if (r != null) {
            return new BigDecimal(r.toString());
        }
        return null;
    }

    public byte[] getBytes(String column) {
        return (byte[])this.get(column);
    }

    public byte[] getBytes(int index) {
        return (byte[])this.get(index);
    }

    public Number getNumber(String column) {
        return (Number)this.get(column);
    }

    public Number getNumber(int index) {
        return (Number)this.get(index);
    }

    public HashMap<String, Object> getResult() {
        return this.result;
    }

    public void setResult(HashMap<String, Object> result) {
        this.result = result;
    }

    public HashMap<Integer, String> getIndexMap() {
        return this.indexMap;
    }

    public void setIndexMap(HashMap<Integer, String> indexMap) {
        this.indexMap = indexMap;
    }

    public void clear() {
        this.indexMap.clear();
        this.result.clear();
    }

    public String toString() {
        return "Record [result=" + this.result + ", indexMap=" + this.indexMap + "]";
    }
}

